/*
 * Copyright (C) 2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.diff;

import java.io.FileInputStream;
import java.io.IOException;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelReader extends Reader {

	public Document read(String path) throws IOException {
		FileInputStream is = new FileInputStream(path);
		POIFSFileSystem fs = new POIFSFileSystem(is);
		HSSFWorkbook book = new HSSFWorkbook(fs);
		Document doc = new Document(Document.Type.EXCEL);

		int sheet = 0;
		int row = 0;
		short column = 0;

		try {
			// V[g̃[v
			int numSheet = book.getNumberOfSheets();
			for (sheet = 0; sheet < numSheet; sheet++) {

				// V[g𑀍삷邽߂̃CX^X擾
				HSSFSheet sheetHandler = book.getSheetAt(sheet);
				String sheetName = book.getSheetName(sheet);

				// V[g̓e1zƂĒǉ
				int rowNum = sheetHandler.getLastRowNum();
				if (sheetHandler.getRow(0) == null) {
					rowNum = -1;
				}
				for (row = 0; row <= rowNum; row++) {
					HSSFRow hssfrow = sheetHandler.getRow(row);
					int columnNum = hssfrow.getLastCellNum();
					for (column = 0; column < columnNum; column++) {
						String value = "";
						HSSFCell hssfcell = hssfrow.getCell(column);
						if (hssfcell != null) {
							HSSFRichTextString cellvalue = hssfcell.getRichStringCellValue();
							if (cellvalue != null) {
								value = cellvalue.getString();
							}
						}
						doc.add(sheetName, row, column, value);
					}
				}
			}

		} catch (RuntimeException e) {
			System.err.println("Excelt@Cǂݍ݃G[F" + "path=[" + path + "],sheet=" + sheet + ",row="
					+ row + ",column=" + column);
			e.printStackTrace();
			throw e;
		}

		return doc;
	}

}
