/*
 * Copyright (C) 2006-2008N {La
 *
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 *
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ*
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 *
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/**
 * @author hiro
 *
 */
public class ExcelDoc extends Document {

	/**
	 * 2z̃Xg
	 */
	private List<String[][]> sheetList = new ArrayList<String[][]>();

	private List<String> sheetNameList = new ArrayList<String>();

	private int page = 0;
	private List<Short> paperSizeList = new ArrayList<Short>();
	private List<Boolean> landscapeList = new ArrayList<Boolean>();
	private List<Short> scaleList = new ArrayList<Short>();
	private List<Short> fitWidthList = new ArrayList<Short>();
	private List<Short> fitHeightList = new ArrayList<Short>();

	private class Position {
		public int sheet = 0;
		public int row = 0;
		public int column = 0;
		public int seq = 0;

		Position() {
		}

		boolean conv(int seq) {
			int count = 0;
			for (String[][] sheetStrings : sheetList) {
				row = 0;
				column = 0;
				for (String[] rowStrings : sheetStrings) {
					count += rowStrings.length;
					if (count > seq) {
						column = seq - (count - rowStrings.length);
						return true;
					}
					row++;
				}
				sheet++;
			}
			return false;
		}

	}

	/**
	 * RXgN^
	 */
	public ExcelDoc() {
		super();
	}

	/**
	 * RXgN^
	 */
	public ExcelDoc(String path) {
		super(path);
	}

	/**
	 * t@Cǂݍݎ{
	 *
	 * @param path
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public void read(String path) throws FileNotFoundException, IOException {
		this.path = path;
		read();
	}

	/**
	 * t@Cǂݍݎ{
	 *
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public void read() throws FileNotFoundException, IOException {
		// 
		sheetList = new ArrayList<String[][]>();
		sheetNameList = new ArrayList<String>();
		page = 0;

		// t@CI[v
		FileInputStream is = new FileInputStream(getPath());
		POIFSFileSystem fs = new POIFSFileSystem(is);
		HSSFWorkbook book = new HSSFWorkbook(fs);

		// V[g̃[v
		int numSheet = book.getNumberOfSheets();
		for (int sheet = 0; sheet < numSheet; sheet++) {

			// V[g𑀍삷邽߂̃CX^X擾
			HSSFSheet sheetHandler = book.getSheetAt(sheet);

			// V[g̓e1zƂĒǉ
			int rowNum = sheetHandler.getLastRowNum();
			if (sheetHandler.getRow(0) == null) {
				rowNum = -1;
			}
			String[][] values = new String[rowNum + 1][];
			for (int row = 0; row <= rowNum; row++) {
				HSSFRow hssfrow = sheetHandler.getRow(row);
				int columnNum = hssfrow.getLastCellNum();
				values[row] = new String[columnNum];
				for (short column = 0; column < columnNum; column++) {
					String value = "";
					HSSFCell hssfcell = hssfrow.getCell(column);
					if (hssfcell != null) {
						HSSFRichTextString cellvalue = hssfcell
								.getRichStringCellValue();
						if (cellvalue != null) {
							value = cellvalue.getString();
						}
					}
					values[row][column] = value;
				}
			}
			sheetList.add(values);
			sheetNameList.add(book.getSheetName(sheet));

			// y[W̎擾
			HSSFPrintSetup printSetup = sheetHandler.getPrintSetup();
			page += printSetup.getCopies();

			// pTCY̎擾
			paperSizeList.add(printSetup.getPaperSize());
			// ̌̎擾
			landscapeList.add(printSetup.getLandscape());
			// {
			scaleList.add(printSetup.getScale());
			// y[W
			fitWidthList.add(printSetup.getFitWidth());
			// cy[W
			fitHeightList.add(printSetup.getFitHeight());
		}
	}

	public String getCell(int sheet, int row, int column) {
		String result;

		try {
			result = sheetList.get(sheet)[row][column];
		} catch (IndexOutOfBoundsException e) {
			// w肳ꂽCfbNX͈͊ȌꍇA
			// uNԋpB
			result = "";
		}

		return result;
	}

	public int getSheetSize() {
		return sheetList.size();
	}

	public int getRowSize(int sheet) {
		return sheetList.get(sheet).length;
	}

	public int getColumnSize(int sheet, int row) {
		return sheetList.get(sheet)[row].length;
	}

	/**
	 * Excel̓e𕶎̈ꎟzƂĎ擾B
	 *
	 * @return z
	 */
	public String[] getArray() {
		List<String> list = new ArrayList<String>();
		for (String[][] table : sheetList) {
			for (String[] row : table) {
				for (String cell : row) {
					list.add(cell);
				}
			}
		}
		return list.toArray(new String[] {});
	}

	/**
	 * 󂩁H
	 *
	 * @return ̏ꍇtrue
	 */
	public boolean isEmpty() {
		Position pos = new Position();
		return !pos.conv(1);
	}

	/**
	 * @param seq
	 *            V[PXԍiSV[g̃Zӂɕ\ԍj
	 * @return V[g
	 */
	public String getSheetName(int seq) {
		Position pos = new Position();
		if (pos.conv(seq)) {
			return sheetNameList.get(pos.sheet);
		} else {
			throw new IllegalArgumentException("V[PXԍ=" + seq);
		}
	}

	/**
	 * w肳ꂽV[PXԍ̃Z̍sCfbNXԋpB
	 *
	 * @param seq
	 *            V[PXԍiSV[g̃Zӂɕ\ԍj
	 * @return sCfbNX
	 */
	public int getRow(int seq) {
		Position pos = new Position();
		if (pos.conv(seq)) {
			return pos.row;
		} else {
			throw new IllegalArgumentException("V[PXԍ=" + seq);
		}
	}

	/**
	 * w肳ꂽV[PXԍ̃Z̗CfbNXԋpB
	 *
	 * @param seq
	 *            V[PXԍiSV[g̃Zӂɕ\ԍj
	 * @return CfbNX
	 */
	public int getColumn(int seq) {
		Position pos = new Position();
		if (pos.conv(seq)) {
			return pos.column;
		} else {
			throw new IllegalArgumentException("V[PXԍ=" + seq);
		}
	}

	/**
	 * V[g̃y[W擾B
	 *
	 * @return y[W
	 */
	public int getPage() {
		return page;
	}

	/**
	 * pTCY擾B
	 *
	 * @return pTCY
	 */
	public String getPaperSizeString() {
		String result = null;
		for (short paperSize : paperSizeList) {
			if (paperSize != paperSizeList.get(0)) {
				return "";
			} else {
				switch (paperSizeList.get(0)) {
				case HSSFPrintSetup.A4_PAPERSIZE:
					result = "A4";
					break;
				case HSSFPrintSetup.A5_PAPERSIZE:
					result = "A5";
					break;
				default:
					result = String.valueOf(paperSizeList.get(0));
				}
			}
		}
		return result;
	}

	/**
	 * ̌擾B
	 *
	 * @return ̌
	 */
	public String getLandscapeString() {
		String result = null;
		for (boolean landscape : landscapeList) {
			if (landscape != landscapeList.get(0)) {
				return "";
			} else {
				if (landscapeList.get(0)) {
					result = "";
				} else {
					result = "c";
				}
			}
		}
		return result;
	}

	/**
	 * {擾B
	 *
	 * @return {
	 */
	public String getScaleString() {
		String result = null;
		for (short scale : scaleList) {
			if (scale != scaleList.get(0)) {
				return "";
			} else {
				result = String.valueOf(scaleList.get(0)) + "%";
			}
		}
		return result;
	}

	/**
	 * y[W擾B
	 *
	 * @return y[W
	 */
	public String getFitWidthString() {
		String result = null;
		for (short width : fitWidthList) {
			if (width != fitWidthList.get(0)) {
				return "";
			} else {
				result = String.valueOf(fitWidthList.get(0));
			}
		}
		return result;
	}

	/**
	 * cy[W擾B
	 *
	 * @return cy[W
	 */
	public String getFitHeightString() {
		String result = null;
		for (short height : fitHeightList) {
			if (height != fitHeightList.get(0)) {
				return "";
			} else {
				result = String.valueOf(fitHeightList.get(0));
			}
		}
		return result;
	}
}
