/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskTrackerStatus;

class LimitTasksPerJobTaskScheduler
extends JobQueueTaskScheduler {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskLimitedJobQueueTaskScheduler");
    public static final String MAX_TASKS_PER_JOB_PROPERTY = "mapred.jobtracker.taskScheduler.maxRunningTasksPerJob";
    private long maxTasksPerJob;

    @Override
    public synchronized void start() throws IOException {
        super.start();
        QueueManager queueManager = this.taskTrackerManager.getQueueManager();
        String queueName = queueManager.getJobQueueInfos()[0].getQueueName();
        queueManager.setSchedulerInfo(queueName, "Maximum Tasks Per Job :: " + String.valueOf(this.maxTasksPerJob));
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
        this.maxTasksPerJob = conf.getLong(MAX_TASKS_PER_JOB_PROPERTY, Long.MAX_VALUE);
        if (this.maxTasksPerJob <= 0L) {
            String msg = "mapred.jobtracker.taskScheduler.maxRunningTasksPerJob is set to zero or a negative value. Aborting.";
            LOG.fatal((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Task> assignTasks(TaskTrackerStatus taskTracker) throws IOException {
        int numTaskTrackers = this.taskTrackerManager.getClusterStatus().getTaskTrackers();
        Collection<JobInProgress> jobQueue = this.jobQueueJobInProgressListener.getJobQueue();
        int mapTasksNumber = taskTracker.countMapTasks();
        int reduceTasksNumber = taskTracker.countReduceTasks();
        int maximumMapTasksNumber = taskTracker.getMaxMapTasks();
        int maximumReduceTasksNumber = taskTracker.getMaxReduceTasks();
        int[] maxMapAndReduceLoad = this.getMaxMapAndReduceLoad(maximumMapTasksNumber, maximumReduceTasksNumber);
        int maximumMapLoad = maxMapAndReduceLoad[0];
        int maximumReduceLoad = maxMapAndReduceLoad[1];
        int beginAtStep = this.maxTasksPerJob != Long.MAX_VALUE ? 0 : 2;
        ArrayList<Task> assignedTasks = new ArrayList<Task>();
        block3: for (int step = beginAtStep; step <= 3; ++step) {
            if ((step == 0 || step == 2) && mapTasksNumber >= maximumMapLoad || (step == 1 || step == 3) && reduceTasksNumber >= maximumReduceLoad) continue;
            Collection<JobInProgress> collection = jobQueue;
            synchronized (collection) {
                for (JobInProgress job : jobQueue) {
                    Task task;
                    if (job.getStatus().getRunState() != 1 || (step == 0 || step == 1) && (long)(job.runningMaps() + job.runningReduces()) >= this.maxTasksPerJob || (task = step == 0 || step == 2 ? job.obtainNewMapTask(taskTracker, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts()) : job.obtainNewReduceTask(taskTracker, numTaskTrackers, this.taskTrackerManager.getNumberOfUniqueHosts())) == null) continue;
                    assignedTasks.add(task);
                    break block3;
                }
                continue;
            }
        }
        return assignedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int[] getMaxMapAndReduceLoad(int localMaxMapLoad, int localMaxReduceLoad) {
        Collection<JobInProgress> jobQueue;
        int numTaskTrackers = this.taskTrackerManager.getClusterStatus().getTaskTrackers();
        int maxMapLoad = 0;
        int maxReduceLoad = 0;
        int neededMaps = 0;
        int neededReduces = 0;
        Collection<JobInProgress> collection = jobQueue = this.jobQueueJobInProgressListener.getJobQueue();
        synchronized (collection) {
            for (JobInProgress job : jobQueue) {
                if (job.getStatus().getRunState() != 1) continue;
                neededMaps += job.desiredMaps() - job.finishedMaps();
                neededReduces += job.desiredReduces() - job.finishedReduces();
            }
        }
        if (numTaskTrackers > 0) {
            maxMapLoad = Math.min(localMaxMapLoad, (int)Math.ceil((double)neededMaps / (double)numTaskTrackers));
            maxReduceLoad = Math.min(localMaxReduceLoad, (int)Math.ceil((double)neededReduces / (double)numTaskTrackers));
        }
        return new int[]{maxMapLoad, maxReduceLoad};
    }
}

