/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class FileDataServlet
extends DfsServlet {
    private static JspHelper jspHelper = null;

    protected URI createUri(FileStatus i, UnixUserGroupInformation ugi, ClientProtocol nnproxy, HttpServletRequest request) throws IOException, URISyntaxException {
        String scheme = request.getScheme();
        DatanodeID host = FileDataServlet.pickSrcDatanode(i, nnproxy);
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
        return new URI(scheme, null, hostname, "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort(), "/streamFile", "filename=" + i.getPath() + "&ugi=" + ugi, null);
    }

    private static DatanodeID pickSrcDatanode(FileStatus i, ClientProtocol nnproxy) throws IOException {
        if (jspHelper == null) {
            jspHelper = new JspHelper();
        }
        LocatedBlocks blks = nnproxy.getBlockLocations(i.getPath().toUri().getPath(), 0L, 1L);
        if (i.getLen() == 0L || blks.getLocatedBlocks().size() <= 0) {
            return jspHelper.randomNode();
        }
        return jspHelper.bestNode(blks.get(0));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UnixUserGroupInformation ugi = this.getUGI(request);
        ClientProtocol nnproxy = this.createNameNodeProxy(ugi);
        try {
            String path = request.getPathInfo() != null ? request.getPathInfo() : "/";
            FileStatus info = nnproxy.getFileInfo(path);
            if (info != null && !info.isDir()) {
                response.sendRedirect(this.createUri(info, ugi, nnproxy, request).toURL().toString());
            } else if (info == null) {
                response.sendError(400, "cat: File not found " + path);
            } else {
                response.sendError(400, "cat: " + path + ": is a directory");
            }
        }
        catch (URISyntaxException e) {
            response.getWriter().println(e.toString());
        }
        catch (IOException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

