// See
//   http://d.hatena.ne.jp/MT22/20080914/1221374572
//     郵便番号の前方か、住所の一部で郵便番号をリアルタイム検索できる UI
//   http://moriwaki.net/cms/?p=254
//

Ext.BLANK_IMAGE_URL = 'ext-3.0.0/resources/images/default/s.gif';

Ext.onReady(function(){

    var ds = new Ext.data.Store({
        baseParams: {
            type: 'json',
            count: 10
        },
        proxy: new Ext.data.ScriptTagProxy({
            url: 'http://zip.ricollab.jp/search'
        }),
        reader: new Ext.data.JsonReader({
            root: 'result',
            totalProperty: 'totalResults',
            id: 'zipcode'
        }, [
        {
            name: 'zipcode',
            mapping: 'zipcode'
        },
        {
            name: 'address',
            mapping: 'address'
        }
        ])
    });
    // ページングの送信パラメータをサイトに合わせて修正
    ds.on('beforeload', function(s, o) {
        o.params.page = o.params.start / o.params.limit + 1;
    });

    var resultTpl = new Ext.XTemplate(
        '<tpl for="."><div class="search-item">',
        '<h3>〒{zipcode}</h3>',
        '{address}',
        '</div></tpl>'
        );
    // 郵便番号入力
    var zip = new Ext.form.TextField({
        applyTo: 'zip',
        maxLength: 7,
        width: 100,
        selectOnFocus: true
    });
    // 住所入力
    var address = new Ext.form.TextField({
        applyTo: 'address',
        width: 350,
        selectOnFocus: true
    });
    // 郵便番号 or 住所検索コンボボックス
    var search = new Ext.form.ComboBox({
        store: ds,
        displayField:'title',
        typeAhead: false,
        loadingText: '検索中...',
        emptyText: '郵便番号の先頭の一部 または住所の一部を入力してください',
        width: 350,
        pageSize:10,
        hideTrigger: true, // トリガー要素を隠す
        tpl: resultTpl,
        applyTo: 'search',
        itemSelector: 'div.search-item',
        queryParam: 'q',
        minChars: 2,
        onSelect: function(record){
            zip.setValue(record.data.zipcode);
            address.setValue(record.data.address);
            this.collapse();
        },
        onKeyUp : function(e){
            if(this.editable !== false && !e.isSpecialKey()){
                this.lastKey = e.getKey();
            }
        }
    });

    var timeout;
    var comboValue = '';

    var focusCombo = function() {
        if (comboValue != search.el.dom.value) {
            if (search.isExpanded()) {
                search.collapse();
            }
            search.onTriggerClick();
            comboValue = search.el.dom.value;
        }
        timeout = setTimeout(focusCombo, 500);
    };

    var blurCombo = function() {
        clearTimeout(timeout);
    };

    search.on({
        'focus': focusCombo,
        'blur': blurCombo
    });

});