
# data/*.yaml の財務情報から売り上げ／利益のグラフを作成する。
#
# 2009-09-12 katoy
# 2009-09-13 katoy

require 'rubygems'
require 'open-uri'
require 'pp'
require 'benchmark'

require 'Msn_finance'

$KCODE = "utf8"
COMPAMYLIST_PATH = 'data/00-companyist.yaml'

GRAPH_KIDS = {
  :Income => [ 
    {:index => '売上高合計', :color =>'0000ff'},
    {:index => '営業利益', :color =>'4b0082'},
    {:index => '税引後利益', :color =>'ff6347'}
  ],
  :Balance => [],
  :CashFlow => [],
}

puts Benchmark.measure { 
  Dir.glob('data/[1-9]*.yaml').each do |f|
    File.open(f) { |io|
      YAML.load_documents(io) do |info|

        sleep 0.5
        info.show(GRAPH_KIDS)
        pp info.company
      end
    }
  end
}
