
require 'rubygems'
require 'mongoid'
require 'pp'
require 'fastercsv'
require 'models/zipcode'

$KCODE = 'utf8'

Mongoid.configure do |conf|
  conf.master = Mongo::Connection.new('localhost', 27017).db('mongoid_test')
end

def import_csv(from)

  # Collection の削除
  Mongoid.database.collection(:zipcodes).drop

  count = 0

  FasterCSV.foreach(from) do |row|

    next if row.size == 0
    # pp row

    Zipcode.create(
      :field00 => "#{row[0]}",
      :field01 => "#{row[1]}",
      :field02 => "#{row[2]}",
      :field03 => "#{row[3]}",
      :field04 => "#{row[4]}",
      :field05 => "#{row[5]}",
      :field06 => "#{row[6]}",
      :field07 => "#{row[7]}",
      :field08 => "#{row[8]}",
      :field09 => row[9] == '1',
      :field10 => row[10] == '1',
      :field11 => row[11] == '1',
      :field12 => row[12] == '1',
      :field13 => row[13].to_sym,
      :field14 => row[14].to_sym
    )
    count += 1
    if count % 1000 == 0
      print '.'
      puts "  #{count}"if count % 10000 == 0
      STDOUT.flush
    end
  end

  # インデックスを作成する。
  Zipcode.create_indexes
end

import_csv('1.csv')


