class ParserUnit
  attr_reader :measure
  attr_reader :unitNumerator
  attr_reader :unitDenominator

  def parse(reader, file='', dir='')

    id = reader['id'].to_sym

    node = reader.expand
    childs = node.children

    node.each_element do |c|
      case c.name
      when 'measure'
        @measure = c.first.to_s.to_sym
      when 'divide'
        c.each_element do |cc|
          case cc.name
          when 'unitNumerator'
            cc.each_element do |ccc|
              case ccc.name
              when 'measure'
                @unitNumerator = ccc.first.to_s.to_sym
              else
                puts "******* ignore(0) #{ccc.name} in unit at line:#{reader.line_number}"
              end
            end
          when 'unitDenominator'
            cc.each_element do |ccc|
              case ccc.name
              when 'measure'
                @unitDenominator = ccc.first.to_s.to_sym
              else
                puts "******* ignore(1) #{ccc.name} in unit at line:#{reader.line_number}"
              end
            end
          else
            puts "******* ignore(2) #{ccc.name} in unit at line:#{reader.line_number}"
          end
        end
      else
        puts "******* ignore(3) #{c.name} in unit at line:#{reader.line_number}"
      end
    end

    reader.next

    {:id=>id, :unit=>self}
  end

  def to_s
    if @measure != nil
      "unit id='#{@id.to_s}' measure='#{@measure.to_s}'"
    else
      "unit id='#{@id.to_s}' unitNumerator='#{@unitNumerator.to_s}' unitDenominator='#{@unitDenominator.to_s}'"
    end
  end

end
