class ParserItem
  attr_reader :name
  attr_reader :uri

  attr_reader :id
  attr_reader :fact
  attr_reader :decimals
  attr_reader :contextref
  attr_reader :unitref

  def parse(reader, file='', dir='')

    @name = reader.local_name.to_sym # if reader.local_name != nil
    @uri = reader.namespace_uri.to_sym # if reader.namespace_uri != nil and reader.namespace_uri.size > 0
    @id = reader['id']

    decimals = reader['decimals']
    contextref = reader['contextRef']
    unitref = reader['unitRef']
    @decimals = decimals.to_s if decimals != nil and decimals != ''
    @contextref = reader['contextRef'].to_sym if contextref != nil and contextref != ''
    @unitref = reader['unitRef'].to_sym if unitref != nil and unitref != ''
    @fact = reader.expand.child if reader.expand != nil

    # pp @fact
    reader.next
    self
  end

  def to_s
    "#{@name.to_s} id='#{@id.to_s}' decimals='#{@decimals.to_s}' contextRef='#{@contextref.to_s}' unitRef='#{@unitref.to_s}' fact='#{@fact}'"
  end
end
