#-*- coding: utf-8; -*-

require 'lib/mastermind'

describe "An all white code with an all white guess" do

  before do
    all_white_code = Mastermind::Code.new(:white, :white, :white, :white)
    all_white_guess = Mastermind::Code.new(:white, :white, :white, :white)
    @score = all_white_code.mark(all_white_guess)
  end

  it "should score 4 black pegs" do
    @score.black.should == 4
  end

  it "should score 0 white pegs" do
    @score.white.should == 0
  end

  specify "should be a winning guess" do
    @score.should be_win
  end

end
