#-*- coding: utf-8; -*-

module Mastermind
  class Score

    def initialize(black, white)
      @black = black
      @white = white
    end

    def black
      @black
    end

    def white
      @white
    end

    def win?
      @black == 4 
    end

    def to_s
      return 'No scoring pegs' if no_score?
      messages = []
      messages << "#{@black} black" if @black > 0
      messages << "#{@white} white" if @white > 0 
      "Score: " + messages.join(', ')
    end

    def no_score?
      @black == 0 && @white == 0
    end 

  end
end
