// See http://scala.sygneca.com/code/xml-pattern-matching
package scalaapplication

/**
 This code is in the public domain.
 @author Ross Judson
 */
object demoXML {
    import scala.xml._;

    def italics(node: Node): Unit = node match {
        case <i>{contents}</i> => Console.println("Italic: " + contents)
        case <node>{c @ _ *}</node> => for (val child <- c) italics(child)
        case _ => { }
    }

    def italics2(e: Node): Unit = {
        e match {
            case Elem(_, "node", _, _, c @ _ *) => c.foreach(k => italics2(k))
            case Elem(_, "i", _, _, c @ _ *) => Console.println("Italic: " + e.text);
            case _ => { }
        }
    }

    def italics3(doc: Elem) = for (val ital <- doc \\ "i") Console.println("Italic: " + ital.text);

    def go(title: String) = {
        val doc =
        <node>
            <node>This is <i>some</i> text content.
                <node>This is <i>deeper</i> stuff.</node>
            </node>
            <node>I am some text.
                <title>I am <i>{title}</i>.</title>
                This is a sentence with an <i>italicized</i> entry.
            </node>
        </node> ;

        // xpath 検索
        Console.println("Looking <title>    : " + doc \\ "title");
        Console.println("Looking <title><i> : " + doc \\ "title" \ "i");
        Console.println("Looking <node>[3]  : " + (doc \\ "node")(3) );

        Console.println("---- Looking <i> First version"); // match
        italics(doc);
        Console.println("---- Second version");  // Elem
        italics2(doc);
        Console.println("---- Third version");  // xpath
        italics3(doc);
    }
    def main(args: Array[String]) = {
  	go("XML Patterns");
    }
}