/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HMACOutputLengthTest
extends TestCase {
    private static DocumentBuilderFactory dbf = null;
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$signature$HMACOutputLengthTest == null ? (class$org$apache$xml$security$test$signature$HMACOutputLengthTest = HMACOutputLengthTest.class$("org.apache.xml.security.test.signature.HMACOutputLengthTest")) : class$org$apache$xml$security$test$signature$HMACOutputLengthTest).getName());
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$HMACOutputLengthTest;

    protected void setUp() throws Exception {
        Init.init();
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
    }

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$HMACOutputLengthTest == null ? (class$org$apache$xml$security$test$signature$HMACOutputLengthTest = HMACOutputLengthTest.class$("org.apache.xml.security.test.signature.HMACOutputLengthTest")) : class$org$apache$xml$security$test$signature$HMACOutputLengthTest);
    }

    public HMACOutputLengthTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$signature$HMACOutputLengthTest == null ? (class$org$apache$xml$security$test$signature$HMACOutputLengthTest = HMACOutputLengthTest.class$("org.apache.xml.security.test.signature.HMACOutputLengthTest")) : class$org$apache$xml$security$test$signature$HMACOutputLengthTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void test_signature_enveloping_hmac_sha1_trunclen_0() throws Exception {
        block2: {
            try {
                HMACOutputLengthTest.validate("signature-enveloping-hmac-sha1-trunclen-0-attack.xml");
                HMACOutputLengthTest.fail((String)"Expected HMACOutputLength exception");
            }
            catch (XMLSignatureException xMLSignatureException) {
                System.out.println(xMLSignatureException.getMessage());
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    public void test_signature_enveloping_hmac_sha1_trunclen_8() throws Exception {
        block2: {
            try {
                HMACOutputLengthTest.validate("signature-enveloping-hmac-sha1-trunclen-8-attack.xml");
            }
            catch (XMLSignatureException xMLSignatureException) {
                System.out.println(xMLSignatureException.getMessage());
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    private static void validate(String string) throws Exception {
        System.out.println("Validating " + string);
        File file = new File(BASEDIR + SEP + "data" + SEP + "javax" + SEP + "xml" + SEP + "crypto" + SEP + "dsig" + SEP, string);
        Document document = dbf.newDocumentBuilder().parse(file);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new Exception("Couldn't find signature Element");
        }
        Element element = (Element)nodeList.item(0);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURI().toString());
        SecretKey secretKey = xMLSignature.createSecretKey("secret".getBytes("ASCII"));
        System.out.println("Validation status: " + xMLSignature.checkSignatureValue((Key)secretKey));
    }

    public void test_generate_hmac_sha1_40() throws Exception {
        block2: {
            System.out.println("Generating ");
            Document document = dbf.newDocumentBuilder().newDocument();
            XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", 40, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            try {
                xMLSignature.sign((Key)HMACOutputLengthTest.getSecretKey("secret".getBytes("ASCII")));
                HMACOutputLengthTest.fail((String)"Expected HMACOutputLength Exception");
            }
            catch (XMLSignatureException xMLSignatureException) {
                System.out.println(xMLSignatureException.getMessage());
                if (xMLSignatureException.getMsgID().equals("algorithms.HMACOutputLengthMin")) break block2;
                HMACOutputLengthTest.fail((String)xMLSignatureException.getMessage());
            }
        }
    }

    private static SecretKey getSecretKey(final byte[] byArray) {
        return new SecretKey(){

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return byArray;
            }

            public String getAlgorithm() {
                return "SECRET";
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

