/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class jobhistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printJob(String trackerHostName, String trackerid, String jobId, String jobName, String user, Path logFile, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td>" + trackerHostName + "</td>");
        out.print("<td>" + new Date(Long.parseLong(trackerid)) + "</td>");
        out.print("<td><a href=\"jobdetailshistory.jsp?jobid=" + jobId + "&logFile=" + logFile.toString() + "\">" + jobId + "</a></td>");
        out.print("<td>" + jobName + "</td>");
        out.print("<td>" + user + "</td>");
        out.print("</tr>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block13: {
            Path[] jobFiles;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block12: {
                String historyLogDir;
                FileSystem fs;
                PathFilter jobLogFileFilter;
                block11: {
                    PageContext pageContext = null;
                    HttpSession session = null;
                    ServletContext application = null;
                    ServletConfig config = null;
                    out = null;
                    jobhistory_jsp page = this;
                    _jspx_out = null;
                    _jspx_page_context = null;
                    response.setContentType("text/html; charset=UTF-8");
                    _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                    application = pageContext.getServletContext();
                    config = pageContext.getServletConfig();
                    session = pageContext.getSession();
                    _jspx_out = out = pageContext.getOut();
                    this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                    out.write(10);
                    out.write("\n<html>\n<head>\n<title>Hadoop Map/Reduce Administration</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n</head>\n<body>\n<h1>Hadoop Map/Reduce History Viewer</h1>\n<hr>\n<h2>Available History </h2>\n");
                    jobLogFileFilter = new PathFilter(){

                        @Override
                        public boolean accept(Path path) {
                            return !path.getName().endsWith(".xml");
                        }
                    };
                    fs = (FileSystem)application.getAttribute("fileSys");
                    historyLogDir = (String)application.getAttribute("historyLogDir");
                    if (fs != null) break block11;
                    out.println("Null file system. May be namenode is in safemode!");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                jobFiles = FileUtil.stat2Paths(fs.listStatus(new Path(historyLogDir), jobLogFileFilter));
                if (null != jobFiles) break block12;
                out.println("NULL files !!!");
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                Arrays.sort(jobFiles, new Comparator<Path>(){

                    @Override
                    public int compare(Path p1, Path p2) {
                        String dp1 = null;
                        String dp2 = null;
                        try {
                            dp1 = JobHistory.JobInfo.decodeJobHistoryFileName(p1.getName());
                            dp2 = JobHistory.JobInfo.decodeJobHistoryFileName(p2.getName());
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                        String[] split1 = dp1.split("_");
                        String[] split2 = dp2.split("_");
                        int res = new Date(Long.parseLong(split1[1])).compareTo(new Date(Long.parseLong(split2[1])));
                        if (res == 0) {
                            res = new Date(Long.parseLong(split1[3])).compareTo(new Date(Long.parseLong(split2[3])));
                        }
                        if (res == 0) {
                            Long l1 = Long.parseLong(split1[4]);
                            res = l1.compareTo(Long.parseLong(split2[4]));
                        }
                        return res;
                    }
                });
                out.print("<table align=center border=2 cellpadding=\"5\" cellspacing=\"2\">");
                out.print("<tr><td align=\"center\" colspan=\"9\"><b>Available Jobs </b></td></tr>\n");
                out.print("<tr>");
                out.print("<td>Job tracker Host Name</td><td>Job tracker Start time</td><td>Job Id</td><td>Name</td><td>User</td>");
                out.print("</tr>");
                HashSet<String> displayedJobs = new HashSet<String>();
                for (Path jobFile : jobFiles) {
                    String decodedJobFileName = JobHistory.JobInfo.decodeJobHistoryFileName(jobFile.getName());
                    String[] jobDetails = decodedJobFileName.split("_");
                    String trackerHostName = jobDetails[0];
                    String trackerStartTime = jobDetails[1];
                    String jobId = jobDetails[2] + "_" + jobDetails[3] + "_" + jobDetails[4];
                    String user = jobDetails[5];
                    String jobName = jobDetails[6];
                    if (displayedJobs.contains(jobId)) continue;
                    displayedJobs.add(jobId);
                    String encodedJobFileName = JobHistory.JobInfo.encodeJobHistoryFileName(jobFile.getName());
                    out.write("\n<center>\n");
                    this.printJob(trackerHostName, trackerStartTime, jobId, jobName, user, new Path(jobFile.getParent(), encodedJobFileName), out);
                    out.write("\n</center> \n");
                }
                out.write(10);
                out.write(" \n</body></html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

