/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class browseDirectory_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateDirectoryStructure(JspWriter out, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String target;
        DFSClient dfs;
        String dir = req.getParameter("dir");
        if (dir == null || dir.length() == 0) {
            out.print("Invalid input");
            return;
        }
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        if (!(dfs = new DFSClient(JspHelper.nameNodeAddr, JspHelper.conf)).exists(target = dir)) {
            out.print("<h3>File or directory : " + target + " does not exist</h3>");
            JspHelper.printGotoForm(out, namenodeInfoPort, target);
        } else {
            if (!dfs.isDirectory(target)) {
                List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(dir, 0L, 1L).getLocatedBlocks();
                LocatedBlock firstBlock = null;
                DatanodeInfo[] locations = null;
                if (blocks.size() > 0) {
                    firstBlock = blocks.get(0);
                    locations = firstBlock.getLocations();
                }
                if (locations == null || locations.length == 0) {
                    out.print("Empty file");
                } else {
                    DatanodeInfo chosenNode = jspHelper.bestNode(firstBlock);
                    String fqdn = InetAddress.getByName(chosenNode.getHost()).getCanonicalHostName();
                    String datanodeAddr = chosenNode.getName();
                    int datanodePort = Integer.parseInt(datanodeAddr.substring(datanodeAddr.indexOf(58) + 1, datanodeAddr.length()));
                    String redirectLocation = "http://" + fqdn + ":" + chosenNode.getInfoPort() + "/browseBlock.jsp?blockId=" + firstBlock.getBlock().getBlockId() + "&blockSize=" + firstBlock.getBlock().getNumBytes() + "&genstamp=" + firstBlock.getBlock().getGenerationStamp() + "&filename=" + URLEncoder.encode(dir, "UTF-8") + "&datanodePort=" + datanodePort + "&namenodeInfoPort=" + namenodeInfoPort;
                    resp.sendRedirect(redirectLocation);
                }
                return;
            }
            FileStatus[] files = dfs.listPaths(target);
            String[] headings = new String[]{"Name", "Type", "Size", "Replication", "Block Size", "Modification Time", "Permission", "Owner", "Group"};
            out.print("<h3>Contents of directory ");
            JspHelper.printPathWithLinks(dir, out, namenodeInfoPort);
            out.print("</h3><hr>");
            JspHelper.printGotoForm(out, namenodeInfoPort, dir);
            out.print("<hr>");
            File f = new File(dir);
            String parent = f.getParent();
            if (parent != null) {
                out.print("<a href=\"" + req.getRequestURL() + "?dir=" + parent + "&namenodeInfoPort=" + namenodeInfoPort + "\">Go to parent directory</a><br>");
            }
            if (files == null || files.length == 0) {
                out.print("Empty directory");
            } else {
                jspHelper.addTableHeader(out);
                int row = 0;
                jspHelper.addTableRow(out, headings, row++);
                String[] cols = new String[headings.length];
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].getPath().toString().endsWith(".crc")) continue;
                    if (!files[i].isDir()) {
                        cols[1] = "file";
                        cols[2] = StringUtils.byteDesc(files[i].getLen());
                        cols[3] = Short.toString(files[i].getReplication());
                        cols[4] = StringUtils.byteDesc(files[i].getBlockSize());
                    } else {
                        cols[1] = "dir";
                        cols[2] = "";
                        cols[3] = "";
                        cols[4] = "";
                    }
                    String datanodeUrl = req.getRequestURL() + "?dir=" + URLEncoder.encode(files[i].getPath().toString(), "UTF-8") + "&namenodeInfoPort=" + namenodeInfoPort;
                    cols[0] = "<a href=\"" + datanodeUrl + "\">" + files[i].getPath().getName() + "</a>";
                    cols[5] = FsShell.dateForm.format(new Date(files[i].getModificationTime()));
                    cols[6] = files[i].getPermission().toString();
                    cols[7] = files[i].getOwner();
                    cols[8] = files[i].getGroup();
                    jspHelper.addTableRow(out, cols, row++);
                }
                jspHelper.addTableFooter(out);
            }
        }
        String namenodeHost = JspHelper.nameNodeAddr.getHostName();
        out.print("<br><a href=\"http://" + InetAddress.getByName(namenodeHost).getCanonicalHostName() + ":" + namenodeInfoPort + "/dfshealth.jsp\">Go back to DFS home</a>");
        dfs.close();
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        browseDirectory_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write("\n\n<html>\n<head>\n<style type=text/css>\n<!--\nbody \n  {\n  font-face:sanserif;\n  }\n-->\n</style>\n");
            JspHelper.createTitle(out, request, request.getParameter("dir"));
            out.write("\n</head>\n\n<body onload=\"document.goto.dir.focus()\">\n");
            try {
                this.generateDirectoryStructure(out, request, response);
            }
            catch (IOException ioe) {
                String msg = ioe.getLocalizedMessage();
                int i = msg.indexOf("\n");
                if (i >= 0) {
                    msg = msg.substring(0, i);
                }
                out.print("<h3>" + msg + "</h3>");
            }
            out.write("\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

