
# See http://majesticseacreature.com/talks/rubyconf08.pdf

require 'rubygems'
require 'open-uri' 
require 'prawn' 
require 'prawn/layout'


Prawn::Document.generate("github-invoice.pdf", :top_margin => 68) do 
  # font "/Library/Fonts/mikachan.ttf"
  font "/Library/Fonts/ipam.ttf"
  text "Invoice / Receipt", :size => 24
  text "送付状", :size => 24

  move_down 30
  text "Account billed: zzz (zzz@foo.org)", :size => 14 

  move_down 20 

  time = Time.now.strftime("%m-%d-%y %I:%M%p %Z") 
  col_widths =  { 0 => 200, 1 => 80, 2 => 80 } 

  table [
    [time, "Small", "9.00"],
    [time, "Large", "12.00"],
  ],
    :headers       => %w[Date Plan Price],
    :row_colors    => %w[eeeeee ffffff],
    :align         => { 2 => :right },
    :align_headers => :left,
    :widths        => col_widths

  move_down 40 
  stroke_horizontal_rule 

  move_down 10 
  text "Logical Awesome, LLC\n582 Market Street, Suite 700\n" << 
    "San Francisco, CA 94104\nsupport@github.com", :size => 14 

  image open("http://github.com/images/modules/header/logo.png"), 
    :at => [345, bounds.top + 25], :scale => 1.25

  image "paid.png", :at => [125, 400], :scale => 1.6 
end
