
# charts/marketlist.yaml にある企業の株価グラフを作成する。
# (chart/*yaml は利用していない。yahoo サイトのグラフを download しているだけ)
# 2009-09-26 katoy

require 'rubygems'
require 'open-uri'
require 'kconv'
require 'ya2yaml'
require 'pp'
require 'benchmark'

$KCODE = "utf8"

# 企業一覧データを読み込む。
def load_marketlist
  obj = nil
  File.open( "charts/marketlist.yaml" ) { |io|
    YAML.load_documents(io) do |y|
      obj = y
    end
  }
  obj
end

def chart_url(id, market)
  # t=5y: ５年
  "http://gchart.yahoo.co.jp/z?s=#{id}.#{market}&t=5y&q=c&l=off&z=m&p=m65,m130,s&a=v&c="
end

def save_image(url, path)
  File.open(path, 'wb') do |file|
    open(url) do |data|
      file.write(data.read)
    end
  end
end

puts Benchmark.measure {
  market = load_marketlist

  num = 0
  market.each do |id, m|
    # next if File.exists?"images/charts/#{id}#{m[0]}.png"

    sleep 1 if num % 10 == 0
    num += 1
    begin
      url = chart_url(id, m[0])
      save_image(url, "images/charts/#{id}#{m[0]}.png")
      pp "#{id} #{m[0]}"
    rescue => e
      pp "error #{id} #{m[0]}"
      pp e
    end
  end
}
