
require 'Inifile'

describe Inifile, "when empty" do
  before do
    @ini = Inifile.new
  end

  it "should be empty" do
    @ini.parse_lines([]).size.should == 0
  end

  it "comment" do
    lines = [";comment"]
    @ini.parse_lines(lines).size.should == 0
  end

  it "syntax error" do
    lines = ["AAAAAAA"]
    begin
      @ini.parse_lines(lines).size.should == 0
    rescue => exc
      exc.message.should == "Syntex Error: line 1: 'AAAAAAA'"
    end
  end

  after do
    @ini = nil
  end
end

describe Inifile, "when no setting" do
  before do
    @ini = Inifile.new
  end

  it "" do
    lines = ["[A]"]
    settings = @ini.parse_lines(lines)
    settings.should == {}
  end

  it "" do
    lines = ["[A]", "   [B]"]
    settings = @ini.parse_lines(lines)
    settings.should == {}
  end

  it "" do
    lines = ["", " \t      "]
    settings = @ini.parse_lines(lines)
    settings.should == {}
  end

  after do
    @ini = nil
  end
end

describe Inifile, "when 2 lines" do
  before do
    @ini = Inifile.new
  end

  it "" do
    lines = ["[A]", "  key = val"]
    settings = @ini.parse_lines(lines)
    settings.should == {"A"=>[{:key=>"val"}]}

    lines = ["[B]", '  key = "val"']
    settings = @ini.parse_lines(lines)
    settings.should == {"B"=>[{:key=>'"val"'}]}

    lines = ["\t[C]", "\tkey\t=\t\"val\"\t"]
    settings = @ini.parse_lines(lines)
    settings.should == {"C"=>[{:key=>'"val"'}]}
  end

  after do
    @ini = nil
  end
end

describe Inifile, "when normal file" do
  before do
    @ini = Inifile.new
  end

  it "" do
    settings = @ini.parse_file('spec/test00.ini')
    settings.should == 
      {"FEED"=>[{:CLASS=>'"BSRSS20Document"'}],
       "SMARTY"=>[{:TEMPLATE_ENCODING=>'"utf-8"'}],
      ".carrot"=>[{:CARROT_VER=>'"1.9.7"'},
                  {:SCRIPT_ENCODING=>'"utf-8"'},
                  {:SERVER_ACCESSOR=>'"s"'}]}
  end

  it "" do
    ans = <<EOS
[FEED]
  CLASS = "BSRSS20Document"

[SMARTY]
  TEMPLATE_ENCODING = "utf-8"

[.carrot]
  CARROT_VER = "1.9.7"
  SCRIPT_ENCODING = "utf-8"
  SERVER_ACCESSOR = "s"
EOS

    settings = @ini.parse_file('spec/test00.ini')
    @ini.generate_lines(settings).join("\n").should == ans
  end

  after do
    @ini = nil
  end
end

