
var page = 1;
var results_per_page = 3;

Ext.onReady(function(){

    //ストアの設定
    var store = new Ext.data.JsonStore({
        //Twitter Search APIをJSONPで利用
        proxy:new Ext.data.ScriptTagProxy({
            url:'http://search.twitter.com/search.json'
        }),
        paramNames:{
            start:'page',
            limit:'results_per_page',
            sort: undefined,
            dir:  undefined
        },
        baseParams:{
            q :'extjs',
            page : page,
            rpp : results_per_page
        },
        autoLoad:true,
        root:'results',
        idProperty:'id',
        fields:[
        'profile_image_url',
        'created_at',
        'from_user',
        'metadata',
        'to_user_id',
        'text', //本文
        'id',
        'from_user_id',
        'geo',  //GEOタグ
        'iso_language_code',
        'source'    //クライアントの種類
        ]
    });

    //各レンダラーの設定
    var imgRenderer = function(value,meta,rec,rIndex,cIndex,store){
        return String.format('<div"><img src={0} alt="{1}"/></div>',
            value,
            store.getAt(rIndex).data.from_user
            );
    };

    var titleRenderer = function(value,meta,rec,rIndex,cIndex,store){
        var data = store.getAt(rIndex).data;
        return String.format('<div style="white-space:normal;"><p><a target="_blank" href="http://twitter.com/{0}"><b>{0}</b></a>:{1}</p><br/><span style="color:#CCC">{2}</span></div>',
            data.from_user,
            value,
            data.created_at
            );
    };

    var grid = new Ext.grid.GridPanel({
        renderTo:'grid',
        height:600,
        loadMask:true,
        store:store,
        autoExpandColumn:'title',
        cm:new Ext.grid.ColumnModel({
            columns:[
            {
                id:'id',
                header:'ID',
                dataIndex:'id',
                hidden:true
            },
            {
                id:'img',
                header:'img',
                dataIndex:'profile_image_url',
                renderer:imgRenderer,
                width:60
            },
            {
                id:'title',
                header:'title',
                dataIndex:'text',
                renderer:titleRenderer,
                width:120
            }
            ]
        }),
        tbar:[
        '->',
        {
            xtype:'textfield',
            name:'keyword',
            itemId:'keyword'
        },
        {
            text:'Search',
            iconCls:'search',
            scope:this,
            handler:function(){
                var tbar = grid.getTopToolbar();
                var value = tbar.getComponent('keyword').getValue();

                grid.getStore().load({
                    params:{
                        q : value,
                        page : page,
                        rpp : results_per_page
                    }
                });
            }
        }
        ]
    });

    //自動アップデート
    var task = {
        run:function(){
            store.reload();
        },
        interval:1000 * 30 //msec * sec
    }

    Ext.TaskMgr.start(task);
});
