
//==========================
const PAPER_X = 400;
const PAPER_Y = 400;

const COLOR_NIRMAL = '#AAA';
const COLOR_CLICKED = '#F00';

var center_x = PAPER_X / 2;
var center_y = PAPER_Y / 2;
var center_circle;
var center_str = ' ' + center_x + ' ' + center_y;

// 案内図座標上での中心位置
var transed_org_x = center_x;
var transed_org_y = center_y;

// 直前のマウスドラッグ移動量 (直前との移動差分を算出する為に利用する)
var lastDX;
var lastDY;

function draw_reset() {
// TODO
}

function show_center() {
    var info = document.getElementById('center');
    if (info) {
        var x = Math.floor(transed_org_x * 100) / 100.0;
        var y = Math.floor(transed_org_y * 100) / 100.0;
        info.value = x + ', ' + y;
    }
}
function show_angle() {
    var info = document.getElementById('angle');
    if (info) {
        info.value = current_deg;
    }
}

function show_scale() {
    var info = document.getElementById('scale');
    if (info) {
        info.value = Math.floor(current_scale * 100) / 100.0;
    }
}

/**
 * 案内図を描く。
 */
window.onload = function() {

    show_center();
    show_angle();
    show_scale();

    const paper = new Raphael(document.getElementById('canvas_container'),
        PAPER_X, PAPER_Y);

    // 外枠を描く。
    var out_frame = paper.rect(0, 0, PAPER_X, PAPER_Y).attr({
        fill: '#FFF'
    });

    function drag_move(dx, dy) {
        panning_handler(dx, dy);
    }
    function drag_start() {
        center_circle.ox = center_circle.attr('cx');
        center_circle.oy = center_circle.attr('cy');
        this.attr({
            cursor: 'pointer'
        });
        lastDX = 0;
        lastDY = 0;
    }
    function drag_end() {
        this.attr({
            cursor: ''
        });
        center_str = ' ' + center_x + ' ' + center_y;
    }
    out_frame.drag(drag_move, drag_start, drag_end);

    // コンパス操作で回転させる要素をこの配列に入れる。
    objs = new Array();

    for (var i = 0; i < 15; i++) {
        for (var j = 0; j < 15; j++) {
            var x = paper.rect(i * 20, j * 20, 16, 16).attr({
                'fill': COLOR_NIRMAL,
                'translation': '150 150'
            });
            var id = '' + i + '-' + j;
            x.node.name = id;
            x.node.onclick = function() {
                click_handler(this.name);
            };
            objs[id] = x;
            x.drag(drag_move, drag_start, drag_end);
        }
    }
    var t = paper.text(0, 0, 'B').attr({
        'font-size': 60,
        translation: '200 200'
    });
    objs['text-A'] = t;
    t.drag(drag_move, drag_start, drag_end);

    t = paper.text(0, 0, '美女 蝉').attr({
        'font-size': 40,
        translation: '250 120'
    });
    objs['text-B'] = t;
    t.drag(drag_move, drag_start, drag_end);

    t = paper.text(0, 0, 'ZXZ').attr({
        'font-size': 60,
        translation: '300 250'
    });
    objs['text-C'] = t;
    t.drag(drag_move, drag_start, drag_end);

    t = paper.circle(300, 250, 30);
    objs['circle-1'] = t;
    t.drag(drag_move, drag_start, drag_end);

    center_circle = paper.circle(center_x, center_y, 5).attr({
        fill: '#F00'
    });

    // 回転描画するハンドラー
    function draw_rotate_handler(from, inc, is_animate, speed) {
        const d = normalze_deg(from + inc);
        for (var i in objs) {
            if (is_animate) {
                objs[i].animate({
                    rotation: (from + inc) + center_str
                }, speed);
            } else {
                objs[i].attr({
                    rotation: (from + inc) + center_str
                });
            }

        // TODO: 文字が逆さまにならないような処理を入れること。
        //if (objs[i]['type'] === 'text') {
        //    if (d > 90 ) {
        //        objs[i].attr({
        //            rotation: d - 180
        //        });
        //    } else if ( d < -90) {
        //        objs[i].attr({
        //            rotation: d + 180
        //        });
        //    }
        //}
        }
    }

    // 倍率指定して描画するハンドラー
    function draw_scale_handler(from, to, is_animate, speed) {

        for (var i in objs) {
            var scale_str = to + ' ' + to + center_str;
            if (objs[i]['type'] === 'text') {
                var fsize = objs[i].attrs['font-size'];
                if (is_animate) {
                    objs[i].animate({
                        'font-size': fsize * 1.0 * to / from
                    }, speed);
                } else {
                    objs[i].attr({
                        'font-size': fsize * 1.0 * to / from
                    });
                }
            }

            if (is_animate) {
                objs[i].animate({
                    scale: scale_str
                }, speed * 0.8);
            } else {
                objs[i].attr({
                    scale: scale_str
                });
            }
        }
    }

    function click_handler(id) {
        // alert(id);
        var info = document.getElementById('info_container');
        var rect = objs[id];
        if (rect) {
            info.innerHTML = 'clicked box: [' + id + ']';

            // クリックしたら赤くする、再度 クリックしたら元の色に戻す
            if (rect.attrs['fill'] === COLOR_CLICKED) {
                rect.attr({
                    'fill': COLOR_NIRMAL
                });
            } else {
                rect.attr({
                    'fill': COLOR_CLICKED
                });
            }
        }
    }

    function panning_handler(dx, dy) {
        var tx = dx - lastDX;
        var ty = dy - lastDY;
        for (var i in objs) {
            objs[i].translate(tx, ty);
        }
        lastDX = dx;
        lastDY = dy;
        show_center();
        var rad = Raphael.rad(-current_deg);
        transed_org_x -=
        (Math.cos(rad) * tx - Math.sin(rad) * ty) / current_scale;
        transed_org_y -= 
        (Math.sin(rad) * tx + Math.cos(rad) * ty) / current_scale;
    }

    //
    // コンパスを描く
    // -- 地図と同じエリアに描く場合
    // draw_compass(paper, document.getElementById('canvas_container'),
    //     draw_rotate_handler);
    // -- 地図とは別のエリアに描く場合
    var paper2 = new Raphael(document.getElementById('compass_container'),
        140, 140);
    draw_compass(paper2, document.getElementById('compass_container'),
        draw_rotate_handler);

    // スケールスライダーを描く
    // -- 地図と同じエリアに描く場合
    draw_scale_slider(paper, document.getElementById('canvas_container'),
        draw_scale_handler);
};
