#include <xmodem/xmodem_def.h>
#include <xmodem/xmodem.h>

#ifdef DEBUG_ON_PC
#include <stdio.h>
#endif

static void (*_putchar)( int c );
static int (*_getchar)( int timeout );

static void xmodem_send_block( unsigned char block_no, xmodem_buffer_t data )
{
    int i;
    unsigned char sum = 0;
#ifdef DEBUG_ON_PC
    printf ( "Sending %d\n", block_no );
#endif    
    _putchar( SOH );
    _putchar( block_no );
    _putchar( ~block_no );
    for ( i = 0; i < XMODEM_BLOCK_SIZE; i ++ )
    {
        int c;
        if ( i < data.size )
        {
            c = *((data.buffer) + i);
        }
        else
        {
            c = 0xff;
        }
#ifdef DEBUG_ON_PC
        if ( !(i % 16) ) printf ( "\n" );
        printf ( " %2.2X", c );
#endif
        _putchar( c );
        sum += c;
    }
#ifdef DEBUG_ON_PC
    printf ( "\n" );
#endif
    _putchar( sum );
}

static int wait_for_recv_start( void )
{
    int c;
    while ( 1 )
    {
        c = _getchar( 10 );
#ifdef DEBUG_ON_PC
        if ( c != -1 ){printf ( "Got [%2.2X]\n", c );}
#endif
        if ( c == NAK )
        {
            return 1;
        }
        if ( c == CAN )
        {
            return 0;
        }
    }
}

int xmodem_send( int retry,
                 xmodem_buffer_t (*get_data_callback)( int block_no ),
                 void (*put_char_callback)(int c),
                 int  (*get_char_callback)(int timeout)  )
{
    int c;
    unsigned char block_no = 1;

    _putchar = put_char_callback;
    _getchar = get_char_callback;

    if( wait_for_recv_start() )
    {
#ifdef DEBUG_ON_PC
        printf ( "START\n" );
#endif
        xmodem_buffer_t data;
        while( 1 )
        {
            data = get_data_callback( block_no );
            if ( data.size > 0 )
            {
                int retry_count;
                retry_count = retry;
                while ( --retry )
                {
                    xmodem_send_block( block_no, data );
                    if ( (c = _getchar( 10000 )) == ACK )
                    {
                        break;
                    }
                    else
                    {
#ifdef DEBUG_ON_PC
                        printf ( "ERROR at %d recv %2.2X(%d)\n", block_no, c, c );
                        printf ( "retry\n" );
#endif
                        continue;
                    }
                }
                block_no ++;
            }
            else
            {
                break;
            }
        }
        _putchar( EOT );
        if ( (c = _getchar( 10000 )) != ACK )
        {
#ifdef DEBUG_ON_PC
            printf ( "ERROR at END recv %2.2X(%d)\n", c, c );
#endif
        }
    }
    else 
    {
#ifdef DEBUG_ON_PC
        printf ( "CANCELED\n" );
#endif
    }
#ifdef DEBUG_ON_PC
    printf ( "END\n" );
#endif
    return block_no * XMODEM_BLOCK_SIZE;
}
