#ifndef __XMODEM_H__
#define __XMODEM_H__

#define XMODEM_BLOCK_SIZE (128)

typedef struct
{
    int size;
    unsigned char *buffer;
} xmodem_buffer_t;

int xmodem_send( int retry,
                 xmodem_buffer_t (*get_data_callback)( int block_no ),
                 void (*put_char_callback)(int c),
                 int  (*get_char_callback)(int timeout)  );

int xmodem_recv( int retry,
                 void *recv_buffer,
                 void (*set_data_callback)( int block_no, xmodem_buffer_t data ),
                 void (*put_char_callback)(int c),
                 int  (*get_char_callback)(int timeout)  );

#endif //__XMODEM_H__
