require "find"

ARCH = ARGV.shift

`#{ARCH}-objdump 2>&1`
if $?.to_i / 256 == 127
  printf "#{ARCH} is wrong arch prefix\n"
  exit
end

data = {}
Find::find( '.' ) do |path|

  if File::file?( path ) and path =~ /\.o$/
    `#{ARCH}-objdump -h #{path} 2>&1`.each do |l|
      ll = l.chomp.split
      begin
        name =  ll[1]
        if name[0] == 46
          size =  ll[2].hex
          vma =  ll[3].hex
          lma =  ll[4].hex
          off =  ll[5].hex
          data[ path ] = {} if data[ path ].nil?
          data[ path ][ name ] = {} if data[ path ][ name ].nil?
          data[ path ][ name ][ :size ] = size
          data[ path ][ name ][ :vma ] = vma
          data[ path ][ name ][ :lma ] = lma
          data[ path ][ name ][ :off ] = off
        end
      rescue
      end
    end
  end

end

data.each do |f, d|
  romsize = 0
  ramsize = 0
  d.each do |n, s|
    if n == ".data" || n == ".text" || n =~ /^\.ro/ ||
        n == ".boot" || n == ".handlers" || n == ".api"
      romsize += s[:size]
    elsif n == ".data" || n == ".bss"
      ramsize += s[:size]
    end
  end
  print "#{f}, #{romsize}, #{ramsize}\n"
end
