#include <plathome.h>
#include <internal_api.h>
#include <shell/shell_uart.h>

void shell_uart_init( void )
{
    _uart_init( SHELL_UART_PORT, 0 );
}

int  shell_rx_ready( void )
{
    return _uart_rx_ready( SHELL_UART_PORT );
}

int  shell_tx_ready( void )
{
    return _uart_tx_ready( SHELL_UART_PORT );
}

void shell_putc( int c )
{
    while( !shell_tx_ready() );
    _uart_putc( SHELL_UART_PORT, c );
}

int shell_getc( void )
{
    char c;
    _uart_read_noi( SHELL_UART_PORT, &c, 1 );
    return c;
}

int shell_write( char *str, int num )
{
    int i;
    for( i = 0; i < num; i ++ )
    {
        shell_putc( *str++ );
    }
    return i;
}

