#include <string.h>
#include <shell/shell_uart.h>
#include <shell/shell_string.h>
#include <plathome.h>

static int isdec( char c )
{
    return c >= '0' && c <= '9';
}

long shell_dec2l( char *str )
{
    int i, minusflag = 1;
    long num = -1;
    for(i = 0; i < strlen( str ); i++ )
    {
        if ( str[i] == '-' && num == -1 )
        {
            minusflag = -1;
        }
        else
        {
            if ( isdec(str[i]) )
            {
                if ( num == -1 ) num = 0;
                num *= 10;
                num += str[i] - '0';
            }
        }
    }
    return num * minusflag;
}

static int hextoi( char c )
{
    if (c >= '0' && c <= '9') return c - '0';
    if (c >= 'A' && c <= 'F') return c - 'A' + 10;
    if (c >= 'a' && c <= 'f') return c - 'a' + 10;
    return -1;
}

unsigned long shell_hex2ul( char *str )
{
    int i, n;
    unsigned long num= 0;
    for(i = 0; i < strlen( str ); i++ )
    {
        if ( (n = hextoi(str[i])) != -1 )
        {
            num <<= 4;
            num |= n;
        }
    }
    return num;
}

unsigned long shell_bin2ul( char *str )
{
    int i;
    unsigned long num= 0;
    for(i = 0; i < strlen( str ); i++ )
    {
        if ( str[i] == '0' || str[i] == '1' )
        {
            num <<= 1;
            num |= str[i] - '0';
        }
    }
    return num;
}

