#include <string.h>
#include <bios_api.h>
#include <plathome.h>
#include <drivers.h>

#include <shell/shell_uart.h>
#include <shell/shell_string.h>
#include <shell/shell_printf.h>
#include <shell/xmodem.h>

#include <shell/command.h>

/// \defgroup SHELL_INTERNAL_FLASH FLASHROM֘Ȃ
/// \ingroup SHELL_INTERNAL_COMMANDS
/// FLASHROMւ̏ABIOS̎ȏA[U[Av̏Ȃǂs
//@{
/// BIOS̎ȏ
static int boot( int argc, char **argv );
/// [U[Av̏
static int user( int argc, char **argv );
/// FLASHROMւ̏
static int write( int argc, char **argv );

//@}

static shell_command_list_t const internal_command_table[] =
{
    { "boot",      boot,      "boot                   BIOS̎ȏ" },
    { "user",      user,      "user                   [U[Av̏" },
    { "write",     write,     "write dest source size FLASHROMėp" },
    { "FLASHR}h",0,0 }
};

static addr_t xmodem_data_address;
static void xmodem_get_data( int block_no, unsigned char *buffer )
{
    memcpy( (void *)xmodem_data_address, (void *)buffer, XMODEM_BLOCK_SIZE );
    xmodem_data_address += XMODEM_BLOCK_SIZE;
}

static int boot( int argc, char **argv )
{
    int size = 0;
    xmodem_data_address = FLASH_TEMP_BUFFER_START;
    shell_printf ( "Recieving XMODEM\n" );
    size = xmodem_receive( xmodem_get_data );
    _flash_write_bios( (void *)FLASH_SYSTEM_START, (void *)FLASH_TEMP_BUFFER_START, size );
    return BIOS_NOERR;
}

#ifndef FLASH_TEMP_BUFFER_BIG
static void xmodem_flash_data( int block_no, unsigned char *buffer )
{
    _flash_write( (void *)xmodem_data_address,
                  (void *)buffer,
                  XMODEM_BLOCK_SIZE, 0 );
    xmodem_data_address += XMODEM_BLOCK_SIZE;
}
#endif

static int user( int argc, char **argv )
{
    shell_printf ( "Recieving XMODEM\n" );
#ifdef FLASH_TEMP_BUFFER_BIG
    {
        int size;
        xmodem_data_address = FLASH_TEMP_BUFFER_START;
        size = xmodem_receive( xmodem_get_data );
        _flash_write_bios( (void *)FLASH_USER_START, (void *)FLASH_TEMP_BUFFER_START, size );
    }
#else
    xmodem_data_address = FLASH_USER_START;
    xmodem_receive(xmodem_flash_data);
#endif
    shell_printf ( "Done\n" );
    return BIOS_NOERR;
}

static int write( int argc, char **argv )
{
    addr_t dst, src;
    int length;
    
    if ( argc != 4 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    dst     = ((addr_t)shell_hex2ul( *++argv ));
    src     = ((addr_t)shell_hex2ul( *++argv ));
    length  = ((int)shell_hex2ul( *++argv ));

    if( (
#ifndef FLASH_SYSTEM_START_FROM_ZERO
            (dst >= FLASH_SYSTEM_START) &&
#endif
            (dst < (FLASH_SYSTEM_START+FLASH_SYSTEM_MAX_SIZE))) ||
        (((dst+length) >= FLASH_SYSTEM_START) && ((dst+length) < (FLASH_SYSTEM_START+FLASH_SYSTEM_MAX_SIZE))) )
    {
        shell_printf( "VXëɏƂĂ܂B\n" );
        shell_printf( "flash bootgpĉ\n" );
        return BIOS_SHELL_INVALID_ARGS;
    }

    shell_printf( "Write %8.8X <- %8.8X, %d bytes\n", dst, src, length );

    _flash_write( (void *)dst, (void *)src, length, 1 );
    shell_printf( "\nDone.\n" );
    return BIOS_NOERR;
}

int exec_internal_flash_command( int argc, char **argv )
{
    return exec_command( (shell_command_list_t *)internal_command_table, argc, argv );
}
