#include <string.h>
#include <bios_api.h>
#include <plathome.h>
#include <drivers.h>

#include <shell/shell_uart.h>
#include <shell/shell_printf.h>
#include <shell/getline.h>
#include <shell/scanner.h>

#include <shell/command.h>
#include <shell/internal_commands.h>

static int argc;
static char *argv[ SHELL_ARGUMENT_NUM ];
static char *tmp;

static shell_command_list_t *user_command_table = 0;

int exec_user_command( int argc, char **argv )
{
    if ( user_command_table )
    {
        return exec_command( user_command_table, argc, argv );
    }
    return BIOS_SHELL_NO_COMMAND_LIST;
}

void _shell_command_add( shell_command_list_t *command_table )
{
    user_command_table = command_table;
}


int s_ParseAToken( token_type_t token_type , const char *token )
{
    if ( token_type == TT_SYMBOL )
    {
        argv[argc] = tmp;
        strcpy( tmp, token );
        tmp += (strlen( token ) + 1);
        argc ++;
    }
    return 0;
}

int shell_execline( char *line )
{
    int pin;
        
    argc = 0;
    tmp = line;

    pin = 0;
    while(line[pin])
    {
        s_ScanACharacter( line[pin] );
        pin ++;
    }
    s_ScanACharacter( '\n' );
    if ( argc != 0 )
    {
        int rval;
        rval = exec_internal_command( argc, argv );
        if ( rval < 0 )
        {
            switch( rval )
            {
                case BIOS_SHELL_INVALID_ARGS:
                    shell_printf( "[%s] parameter error see help.\n", *argv );
                    break;
                case BIOS_SHELL_INVALID_COMMAND:
                    shell_printf( "[%s] no such command.\n", *argv );
                    break;
                case BIOS_SHELL_EXIT:
                    return 1;
                default:
                    shell_printf( "Return value %4d\n", rval );
            }
        }
    }
    return 0;
}

void shell( char *prompt )
{
    int state;
    state = _interrupt_disable();

    shell_uart_init();
    shell_printf( "\nCommand Shell for %s\n", Version() );
    char *linebuf;
    while ( 1 )
    {
        int c;
        shell_printf ( "%s", prompt ); // vvg\
        do
        {
            if ( (c = shell_getc()) < 0 ) continue;
        } while ( (linebuf=getline( c )) == 0 );

        if ( shell_execline( linebuf ) )
        {
            _interrupt_restore( state );
            break;
        }
    }
}
