/****************************************************************

    $RCSfile: scanner.c,v $ : 
    $Author: buchio $
    $Date: 2004/10/26 06:22:18 $
    $Revision: 1.1 $

 ****************************************************************/

/****************************************************************/
/*************  includeу[J}N/^錾 **************/
/****************************************************************/
#include <stdio.h>
#include <plathome.h>

#include <shell/scanner.h>
#include <shell/parser.h>


typedef enum {
    false = 0,
    true = 1
} s_boolean_v;

typedef struct {
    s_boolean_v bit : 1 ;
} s_boolean;

#define INPUT_OK            (1)
#define INPUT_INVALID_CHAR  (-1)
#define S_TOKEN_LENGTH_MAX  SHELL_ARGUMENT_LENGTH


typedef enum {
    CH_UNKNOWN,
    CH_SYMBOL,
    CH_DELIMITER,
    CH_OPERATOR,
    CH_BEGIN,
    CH_END
} char_type_t;

typedef enum {
    SS_IDLE,
    SS_SYMBOL,
    SS_DELIMITER
} scanner_state_t;

typedef struct {
    s_boolean valid;
    int c;
} unget_buffer_t;

/****************************************************************/
/*************  local ϐ̐錾  *******************************/
/****************************************************************/

static scanner_state_t state = SS_IDLE;
static unget_buffer_t unget = {{false}, 0}; /* AQbgobt@[͋ */
static char token_buffer[S_TOKEN_LENGTH_MAX + 1] = {'\0'}; /* ͒g[Nobt@ */
static int  token_end = 0;	/* g[N|C^[ */

/****************************************************************/
/*************  local ֐̃vg^Cv錾  *******************/
/****************************************************************/

static void ungetChar( int c );

static char_type_t charTypeOf( int c );

static s_boolean isSymbolChar( int c );
static s_boolean isDelimiter( int c );
static s_boolean isOperator( int c );
static s_boolean isBegin( int c );
static s_boolean isEnd( int c );

static void reduceToken( token_type_t token_type );

/* ################ ȉ֐̂̐錾 ################*/

/****************************************************************/
/*************  v֐ / public method  ***********************/
/****************************************************************/

int s_ScanACharacter( int c )
{
    int result = INPUT_OK;

    token_buffer[token_end ++] = (char)(c & 0xff);
    token_buffer[token_end] = '\0';

    switch( state ){
    case SS_IDLE:
	switch( charTypeOf( c ) ){
	case CH_SYMBOL:
	    state = SS_SYMBOL;
	    break;
	case CH_DELIMITER:
	    state = SS_DELIMITER;
	    break;
	case CH_OPERATOR:
	    reduceToken(TT_OPERATOR); /* Ҍ */
	    break;
	case CH_BEGIN:
	    reduceToken(TT_BEGIN); /* Ҍ */
	    break;
	case CH_END:
	    reduceToken(TT_END); /* Ҍ */
	    break;
	case CH_UNKNOWN:
	    /* G[I */
	    result = INPUT_INVALID_CHAR;
	    break;
	default:
            break;
	}
	break;
    case SS_SYMBOL:
	switch( charTypeOf( c )){
	case CH_SYMBOL:
	    /* p */
	    break;
	case CH_DELIMITER:	/* fall through */
	case CH_OPERATOR:	/* fall through */
	case CH_BEGIN:		/* fall through */
	case CH_END:		/* fall through */
	case CH_UNKNOWN:
	    ungetChar( c );	/* ŃXLȂ */
	    state = SS_IDLE;	/* SS_SYMBOL𔲂 */
	    reduceToken(TT_SYMBOL); /* Ҍ */
	    break;
	default:
            break;
	}
	break;
    case SS_DELIMITER:
	switch( charTypeOf( c )){
	case CH_DELIMITER:
	    /* p */
	    break;
	case CH_SYMBOL:		/* fall through */
	case CH_OPERATOR:	/* fall through */
	case CH_BEGIN:		/* fall through */
	case CH_END:		/* fall through */
	case CH_UNKNOWN:
	    ungetChar( c );	/* ŃXLȂ */
	    state = SS_IDLE;	/* SS_SYMBOL𔲂 */
	    reduceToken(TT_DELIMITER); /* Ҍ */
	    break;
	default:
            break;
	}
	break;
    default:
	break;
    }

    /* AQbgꂽΎōċAď */
    if( unget.valid.bit == true ){
	unget.valid.bit = false;
	s_ScanACharacter( unget.c );
    }
    
    return result;
}

/****************************************************************/
/*************  Tu[` / private method *******************/
/****************************************************************/

static void ungetChar( int c )
{
    token_end --;
    token_buffer[token_end] = '\0';
    unget.valid.bit = true;
    unget.c     = c;
    return ;
}


static char_type_t charTypeOf( int c)
{
    char_type_t result = CH_UNKNOWN;

    if( isSymbolChar( c ).bit == true ){ result = CH_SYMBOL; }
    if( isDelimiter( c ).bit  == true ){ result = CH_DELIMITER; }
    if( isOperator( c ).bit   == true ){ result = CH_OPERATOR; }
    if( isBegin( c ).bit      == true ){ result = CH_BEGIN; }
    if( isEnd( c ).bit        == true ){ result = CH_END; }

    return result;
}


static s_boolean isSymbolChar( int c )
{
    s_boolean result;

    if( (('A' <= c) && (c <= 'Z')) ||
	(('a' <= c) && (c <= 'z')) ||
	(('0' <= c) && (c <= '9')) ||
	(c == '+') ||
	(c == '-') ||
	(c == '/') ||
	(c == '*') ||
	(c == '&') ||
	(c == '|') ||
	(c == '^')
	){
	result.bit = true;
    } else {
	result.bit = false;
    }

    return result;
}

static s_boolean isDelimiter( int c )
{
    s_boolean result;

    if( (c == ' ') ||
	(c == '\t') ||
	(c == '\r') ||
	(c == '\n')
	){
	result.bit = true;
    } else {
	result.bit = false;
    }

    return result;
}

static s_boolean isOperator( int c )
{
    s_boolean result;

    if(	(c == '.') ){
	result.bit = true;
    } else {
	result.bit = false;
    }

    return result;
}

static s_boolean isBegin( int c )
{
    s_boolean result;

    if( (c == '(') ||
	(c == '{') ||
	(c == '[')
	){
	result.bit = true;
    } else {
	result.bit = false;
    }

    return result;
}

static s_boolean isEnd( int c )
{
    s_boolean result;

    if( (c == ')') ||
	(c == '}') ||
	(c == ']')
	){
	result.bit = true;
    } else {
	result.bit = false;
    }

    return result;
}

static void reduceToken( token_type_t token_type )
{
    /* p[T[ɊҌ */
    s_ParseAToken( token_type , token_buffer );

    /* g[Nobt@ */
    token_end = 0;
    token_buffer[0] = '\0';


    return ;
}

/****************************************************************/
/*************  P̃eXg֐ **********************************/
/****************************************************************/

#ifdef __RUN_MODULE_TEST__
#include <stdio.h>
#include <stdlib.h>

int s_ParseAToken( token_type_t tt, const char *token )
{
    printf("\"%32s\"\t%d\n",  token, tt);
    return 0;
}


#define TEST(__TESTNAME__) if(__TESTNAME__() == 1){puts(#__TESTNAME__ "\tPASS \n");} else {puts(#__TESTNAME__ "\tFAIL \n");}

int test1(void){
    char teststring[] = "hogehge.hoge hage+hoge 234.55\n (hige\thoga){gogo.moge.gase\n\t}";
    int pin = 0;
    
    while(teststring[pin]){
	s_ScanACharacter( teststring[pin] );
	pin ++;
    }
    
    return 1;
}

int main(int argc, char *argv[])
{
    TEST(test1);
    return 0;
}

#endif /* __RUN_MODULE_TEST__ */

/**************** End of body ****************/

/*
 * Local variables:
 *  compile-command: "gcc -Wall -g  -I . -D__RUN_MODULE_TEST__ scanner.c -o scanner"
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  tab-width: 8
 * End:
 */
