#include <string.h>
#include <bios_api.h>
#include <plathome.h>

#include <shell/shell_uart.h>
#include <shell/shell_string.h>
#include <shell/shell_printf.h>

#include <shell/command.h>

/// \defgroup SHELL_INTERNAL_COMMANDS VFgݍ݂̃R}hQ
/// \ingroup SHELL
/// VFgݍ݂̃R}h
//@{
/// _v
static int dump( int argc, char **argv );
/// ǂ݂
static int get( int argc, char **argv );
/// 
static int set( int argc, char **argv );
/// tB
static int fill( int argc, char **argv );
/// Tu[`R[
static int call( int argc, char **argv );
/// UARTM
static int load( int argc, char **argv );
/// eXg֐
static int test( int argc, char **argv );
/// FLASHROM
static int flash( int argc, char **argv );
/// OR}h
static int ext( int argc, char **argv );
/// [U[R}h
static int user( int argc, char **argv );
/// I
static int exit_shell( int argc, char **argv );
//@}

static shell_command_list_t const internal_command_table[] =
{
    { "d",         dump,      "[-bhw] [start] [end]     _v" },
    { "get",       get,       "[-bhw] address           ǂ݂" },
    { "set",       set,       "[-bhw] address data      ɏ" },
    { "fill",      fill,      "[-bhw] address data size tB size̓oCg(f[^̐ł͂Ȃ)" },
    { "call",      call,      "address                  Tu[`R[" },
    { "load",      load,      "address                  UARTf[^M" },
    { "test",      test,      "                         eXgpR}h" },
    { "flash",     flash,     "subcommand [args]        FLASHROM flash helpŏڍ" },
    { "ext",       ext,       "subcommand [args]        ǉR}h ext helpŏڍ" },
    { "user",      user,      "subcommand [args]        [U[R}h user helpŏڍ" },
    { "exit",      exit_shell,"VFI" },
    { "R}h",0,0 }
};

static int getlength( char *arg )
{
    if ( *arg == '-' )
    {
        switch( *(arg+1) )
        {
            case 'b':
                return sizeof( byte );
            case 'h':
                return sizeof( hword );
            case 'w':
                return sizeof( word );
            default:
                return -1;
        }
    }
    return 0;
}

static void dispmem( int length, addr_t address )
{
    switch( length )
    {
        case sizeof( byte ):
        {
            byte value;
            value = *(volatile byte *)(address);
            shell_printf( "%2.2X", value );
        }
        break;
        case sizeof( hword ):
        {
            hword value;
            value = *(volatile hword *)(address);
            shell_printf( "%4.4X", value );
        }
        break;
        case sizeof( word ):
        {
            word value;
            value = *(volatile word *)(address);
            shell_printf( "%8.8X", value );
        }
        break;
    }
}

static addr_t start = 0;

static int dump( int argc, char **argv )
{
    int length;
    addr_t end;
    
    if ( argc >= 2 )
    {
        length = getlength( *++argv );
        if ( length < 0 )
        {
            return BIOS_SHELL_INVALID_ARGS;
        }
        if ( length == 0 )
        {
            length = sizeof( byte );
        }
        else
        {
            argc--;
            argv++;
        }
        
        if ( argc > 1 )
        {
            start = ((addr_t)shell_hex2ul( *argv++ )) & ~0x0f;
            if ( argc == 2 )
            {
                end = start + 0x100;
            }
            else
            {
                end   = ((addr_t)shell_hex2ul( *argv ) & ~0x0f);;
                if ( end < start )
                {
                    return BIOS_SHELL_INVALID_ARGS;
                }
            }
        }
        else
        {
            end = start + 0x100;
        }
    }
    else
    {
        length = sizeof( byte );;
        end = start + 0x100;
    }

    while( start < end )
    {
        int i;

        shell_printf( "%8.8X:", start );

        for( i = 0; i < 16; i +=  length )
        {
            shell_putc( ' ' );
            dispmem( length, start + i );
        }
        if ( length == sizeof( byte ) )
        {
            byte c;
            shell_printf( " : " );
            for( i = 0; i < 16; i +=  length )
            {
                c = *((volatile byte *)(addr_t)(start+(addr_t)i));
                if ( ( c < 0x20 ) || ( c > 'z' ) ) shell_putc( '.' );
                else                               shell_putc( c );
            }
        }
        shell_printf( "\n" );
        start += 16;
    }
    start = end;
    
    return BIOS_NOERR;
}

static int get( int argc, char **argv )
{
    addr_t address;
    int length;
    if ( argc <= 1 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    
    length = getlength( *++argv );
    if ( length < 0 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    if ( length == 0 ){length = sizeof( byte );}
    else{argc--;argv++;}

    if ( argc < 2 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    
    address = ((addr_t)shell_hex2ul( *argv++ ));
    dispmem( length, address );
    shell_printf( "\n" );
    return BIOS_NOERR;
}

static int set( int argc, char **argv )
{
    int length;
    addr_t address;
    word value;
    
    if ( argc <= 2 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    
    length = getlength( *++argv );
    if ( length < 0 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    if ( length == 0 ){length = sizeof( byte );}
    else{argc--;argv++;}

    address = ((addr_t)shell_hex2ul( *argv++ ));
    value   = ((word)shell_hex2ul( *argv ));

    switch( length )
    {
        case sizeof( byte ):
        {
            *(volatile byte *)(address) = (byte)value;
        }
        break;
        case sizeof( hword ):
        {
            *(volatile hword *)(address) = (hword)value;
        }
        break;
        case sizeof( word ):
        {
            *(volatile word *)(address) = (word)value;
        }
        break;
    }
    
    return BIOS_NOERR;
}

static int fill( int argc, char **argv )
{
    int length;
    addr_t address;
    word value;
    int size;
    
    if ( argc <= 3 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    
    length = getlength( *++argv );
    if ( length < 0 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    if ( length == 0 ){length = sizeof( byte );}
    else{argc--;argv++;}

    address = ((addr_t)shell_hex2ul( *argv++ ));
    value   = ((word)shell_hex2ul( *argv++ ));
    size    = ((int)shell_hex2ul( *argv ));

    switch( length )
    {
        case sizeof( byte ):
            {
                while( size > 0 )
                {
                    *(volatile byte *)(address) = (byte)value;
                    size -= length;
                    address+= length;
                }
            }
            break;
        case sizeof( hword ):
            {
                while( size > 0 )
                {
                    *(volatile hword *)(address) = (hword)value;
                    size -= length;
                    address+= length;
                }
            }
            break;
        case sizeof( word ):
            {
                while( size > 0 )
                {
                    *(volatile word *)(address) = (word)value;
                    size -= length;
                    address+= length;
                }
            }
            break;
    }
    return BIOS_NOERR;
}

typedef int (*FUNC_t)(int argc, char *argv[]);

static int call( int argc, char **argv )
{
    addr_t address;
    if ( argc <= 1 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    address = ((addr_t)shell_hex2ul( *(argv+1) ));
    return  ((FUNC_t)address)(argc-1, argv+1);
}

#include <shell/xmodem.h>
static addr_t xmodem_data_address;
static void xmodem_get_data( int block_no, unsigned char *buffer )
{
    memcpy( (void *)xmodem_data_address, (void *)buffer, XMODEM_BLOCK_SIZE );
    xmodem_data_address += XMODEM_BLOCK_SIZE;
}

static int load( int argc, char **argv )
{
    if ( argc <= 1 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    xmodem_data_address = ((addr_t)shell_hex2ul( *++argv ));
    shell_printf ( "Recieving XMODEM\n" );
    xmodem_receive( xmodem_get_data );
    return BIOS_NOERR;
}

static int test( int argc, char **argv )
{
    int time, i;

    shell_printf ( "Hello\n" );
    for ( i = 0; i < 0x10000; i += 0x1234 )
    {
        shell_printf ( "Hello %6X, %6x, %8.6x, %8.5X, %8.8x, %8.8X\n", i, i, i, i, i, i );
    }
    shell_printf ( "%s\n", "BAKA" );

    if ( argc <= 1 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    time = ((int)shell_hex2ul( *(argv+1) ));
    shell_printf( "start\n" );
    for( i = 0; i < time; i ++ ) {}
    shell_printf( "end\n" );
    return  BIOS_NOERR;
}

#include <shell/shell_flash.h>
static int flash( int argc, char **argv )
{
    return exec_internal_flash_command( --argc, ++argv );
}

int exec_extra_command( int argc, char **argv );
static int ext( int argc, char **argv )
{
    return exec_extra_command( --argc, ++argv );
}

int exec_user_command( int argc, char **argv );
static int user( int argc, char **argv )
{
    return exec_user_command( --argc, ++argv );
}

static int exit_shell( int argc, char **argv )
{
    return BIOS_SHELL_EXIT;
}

int exec_internal_command( int argc, char **argv )
{
    return exec_command( (shell_command_list_t *)internal_command_table, argc, argv );
}
