#include <string.h>

#include <plathome.h>

#include <shell/shell_uart.h>
#include <shell/shell_printf.h>
#include <shell/getline.h>

static void Cur_Left(int n)
{
    while( n-- )
    {
        shell_write( "\033[D", 3 );
    }
}

static void Cur_Right(int n)
{
    while( n-- )
    {
        shell_write( "\033[C", 3 );
    }
}

static char HistoryBuffer[ SHELL_HISTORY_NUM ][ SHELL_COMMANDLINE_LENGTH ];
static int HistoryPos = 0;

static void showhistory ( void )
{
    int i;
    int his;
    shell_printf("\n");
    for ( i = 0; i < SHELL_HISTORY_NUM; i++ )
    {
        his = i + HistoryPos;
        if ( his > SHELL_HISTORY_NUM ) his -= SHELL_HISTORY_NUM;
        shell_printf ( "%2d : %s\n", his, HistoryBuffer [ his ] );
    }
}


/*
 s:  0x01 or 0x1B,"[2~"
 s:  0x05 or 0x1B,"[5~"
   :  0x10 or 0x1B,"[A"
   :  0x0E or 0x1B,"[B"
 E  :  0x06 or 0x1B,"[C"
   :  0x02 or 0x1B,"[D"
 CR  :  0x0D 0x0A
 TAB :  0x09
 BS  :  0x08
 DEL :  0x04 or 0x1B,"[4~"
*/

static char linebuf[ SHELL_COMMANDLINE_LENGTH ];
char *getline( unsigned char c )
{
    static int CurrentHistoryPos = -1;
    static int len=0, escflag=0, esctmp=0;
    static char *pBuf = 0;
    static char *pTop = 0;

    if ( CurrentHistoryPos == -1 )
    {
        CurrentHistoryPos = HistoryPos;
        len = 0; escflag = 0; esctmp = 0;
        pBuf = pTop = linebuf;
        *pBuf = '\0';
    }

    if ( escflag )
    {
        if ( ( escflag == 1 ) && ( c == '[' ) )
        {
            escflag ++;
        }
        else if ( escflag == 2 )
        {
            if ( (c == '2') || (c == '4') || (c == '5') )
            {
                if ( c == '2' ){esctmp = 1;}
                else{esctmp = c - '0';}
                escflag ++;
            }
            else
            {
                if ( c == 'A' ){c = 0x10;}
                if ( c == 'B' ){c = 0x0e;}
                if ( c == 'C' ){c = 0x06;}
                if ( c == 'D' ){c = 0x02;}
                escflag = 0;
            }
        }
        else if ( (escflag == 3) && (c == '~') )
        {
            c = esctmp;
            escflag = 0;
        }
        else
        {
            escflag = 0;
        }
    }

    if ( !escflag )
    {

#define IsEnd (pBuf == pTop + len)
#define IsTop (pBuf == pTop)
#define CurPos (pBuf - pTop)
#define LineEnd (pTop + len)
        if ( c < ' ' )
        {
            switch ( c )
            {
                case 0x1B: // ESC
                    escflag = 1;
                    break;
                case 0x0D: case 0x0A: // EOL
                    shell_printf("\n");
                    if( !(pBuf == pTop) )
                    {
                        *LineEnd = '\0';
                        if ( strlen ( pTop ) )
                        {
                            strcpy ( HistoryBuffer[HistoryPos], pTop );

                            if ( ++HistoryPos == SHELL_HISTORY_NUM ) HistoryPos = 0;
                        }
                    }
                    CurrentHistoryPos = -1;
                    return pTop;

                    break;
                case 0x06: // E  
                    if ( !IsEnd ) { Cur_Right(1); pBuf ++; }
                    else { /*Beep()*/; }
                    break;
                case 0x02: // 
                    if ( !IsTop ) { Cur_Left(1); pBuf --; }
                    else { /*Beep()*/; }
                    break;
                    
                case 0x01: //s
                    if ( !IsTop )
                    {
                        Cur_Left(CurPos);
                        pBuf = pTop;
                    }
                    break;
                    
                    
                case 0x05: // s
                    if ( pBuf < LineEnd )
                    {
                        Cur_Right(len - CurPos);
                        pBuf = LineEnd;
                    }
                    break;
                    
                case 0x08: // BS  
                    if ( pBuf > pTop )
                    {
                        Cur_Left(1);
                        memmove( pTop + CurPos -1, pTop + CurPos, len - CurPos + 1 );
                        pBuf --;
                        len--;
                        shell_write( pTop + CurPos, len - CurPos );
                        shell_putc( ' ' );
                        Cur_Left(len - CurPos+1);
                    }
                    else
                    {
                        /*Beep()*/;
                    }
                    break;
                case 0x04: // DEL 
                    if ( pBuf < LineEnd )
                    {
                        memmove( pTop+CurPos, pTop+CurPos+1, len-CurPos);
                        shell_write( pTop + CurPos, len-CurPos-1);
                        shell_putc( ' ' );
                        Cur_Left(len - CurPos);
                        len --;
                    }
                    else
                    {
                        /*Beep()*/;
                    }
                    break;
                case 0x10: //   
                case 0x0E: //   
                    if ( CurrentHistoryPos == -1 ) CurrentHistoryPos = HistoryPos;
                    if ( c == 0x10 )
                    {
                        CurrentHistoryPos--;
                        if ( CurrentHistoryPos == -1 )
                        {
                            CurrentHistoryPos = SHELL_HISTORY_NUM - 1;
                        }
                    }
                    
                    if ( c == 0x0E )
                    {
                        CurrentHistoryPos++;
                        if ( CurrentHistoryPos == SHELL_HISTORY_NUM )
                        {
                            CurrentHistoryPos = 0;
                        }
                    }
                    
                    Cur_Left(CurPos);
                    {
                        int p;
                        for ( p = 0 ; p < len; p ++ ) shell_putc( ' ' );
                    }
                    Cur_Left(len);
                    
                    strcpy ( pTop, HistoryBuffer[ CurrentHistoryPos ] );
                    len = strlen ( pTop );
                    pBuf = pTop + len;
                    shell_printf( "%s", pTop  );
                    break;
                    
                case 0x09: // TAB 
                    showhistory();
                default:
                    /*Beep()*/;
                break;
            }
        }
        else
        {
            if ( len == SHELL_COMMANDLINE_LENGTH )
            {
                /*Beep()*/;
            }
            else
            {
                if ( *pBuf == '\0' )
                {
                    shell_putc( c );
                    *pBuf ++ = c;
                    *pBuf = '\0';
                    len ++;
                }
                else
                {
                    memmove( pTop+CurPos, pTop+CurPos-1, len - CurPos + 1 );
                    *pBuf++ = c;
                    len ++;
                    *LineEnd = '\0';
                    shell_putc( c );
                    shell_write( pTop + CurPos, len - CurPos );
                    Cur_Left( len - CurPos );
                }
            }
        }
    }
    return 0;
}
