#include <bios_api.h>
#include <internal_api.h>
#include <plathome.h>

#include <shell/shell_uart.h>
#include <shell/shell_printf.h>

int _bios_call_api( int API_NUM, int LPARAM, void *RPARAM )
{
    switch( API_NUM )
    {

        case API_REBOOT:
        case API_INTERRUPT_STATUS:
        case API_INTERRUPT_ENABLE:
        case API_INTERRUPT_DISABLE:
        case API_INTERRUPT_RESTORE:
        case API_SHELL_GET_MODE:
        case API_SHELL_COMMAND_ADD:
            return _bios_call_api_direct( API_NUM, LPARAM, RPARAM );
        case API_SHELL_SET_MODE:
        case API_INTTERRUPT_SET_ENABLE:
        case API_INTTERRUPT_SET_HANDLER:
        case API_UART_INIT:
        case API_UART_SET_TIMEOUT:
        case API_UART_READ:
        case API_UART_WRITE:
        case API_UART_SET_READ_CALLBACK:
        case API_UART_SET_WRITE_CALLBACK:
        case API_TIMER_INIT:
        case API_TIMER_SET_CALLBACK:
        case API_FLASH_WRITE:
            return _bios_call_api_swi( API_NUM, LPARAM, RPARAM );
    }
    return BIOS_NOERR;
}

int _bios_call_api_direct( int API_NUM, int LPARAM, void *RPARAM )
{
    switch( API_NUM )
    {
        case API_REBOOT:
            shell_printf( "API_REBOOT" );
            break;

        case API_SHELL_COMMAND_ADD:
            _shell_command_add( (shell_command_list_t *)RPARAM );
            return BIOS_NOERR;
            
        case API_SHELL_GET_MODE:
            return  _shell_mode_get();
            
        case API_SHELL_SET_MODE:
            _shell_mode_set( LPARAM, (char *)RPARAM );
            return BIOS_NOERR;
            
        case API_INTERRUPT_STATUS:
            return _interrupt_status();

        case API_INTERRUPT_ENABLE:
            return _interrupt_enable();

        case API_INTERRUPT_DISABLE:
            return _interrupt_disable();

        case API_INTERRUPT_RESTORE:
            _interrupt_restore( LPARAM );
            return BIOS_NOERR;

        case API_INTTERRUPT_SET_ENABLE:
        {
            int enable = (int)RPARAM;
            if ( enable )
            {
                return _interrupt_enable_num( LPARAM );
            }
            else
            {
                return _interrupt_disable_num( LPARAM );
            }
        }
        case API_INTTERRUPT_SET_HANDLER:
            return _interrupt_set_handler( LPARAM, (bios_interrupt_handler_t)RPARAM );

        case API_UART_INIT:
        {
            int rval;
            rval = _uart_init( LPARAM, (bios_uart_param_t *)RPARAM );
            _uart_interrupt_enable( SHELL_UART_PORT );
            _uart_recv_interrupt_enable( SHELL_UART_PORT );
            _uart_send_interrupt_enable( SHELL_UART_PORT );
            return rval;
        }

        case API_UART_SET_TIMEOUT:
            shell_printf( "API_UART_SET_TIMEOUT" );
            break;

        case API_UART_READ:
        {
            int len;
            char *buf;
            len = ((bios_uart_buffer_t *)RPARAM)->length;
            buf = ((bios_uart_buffer_t *)RPARAM)->buffer;
            return _uart_read_i( LPARAM, buf, len );
        }
        case API_UART_WRITE:
        {
            int len;
            char *buf;
            len = ((bios_uart_buffer_t *)RPARAM)->length;
            buf = ((bios_uart_buffer_t *)RPARAM)->buffer;
            return _uart_write_i( LPARAM, buf, len );
        }
        case API_UART_SET_READ_CALLBACK:
            return _uart_recv_interrupt_set_handler( LPARAM, (bios_uart_callback_t)RPARAM);

        case API_UART_SET_WRITE_CALLBACK:
            return _uart_send_interrupt_set_handler( LPARAM, (bios_uart_callback_t)RPARAM);

        case API_TIMER_INIT:
            return _timer_init();

        case API_TIMER_SET_CALLBACK:
            return _timer_set_callback((bios_timer_callback_t)RPARAM);

        case API_FLASH_WRITE:
            _flash_write( ((bios_flash_param_t *)RPARAM)->destination,
                          ((bios_flash_param_t *)RPARAM)->source,
                          ((bios_flash_param_t *)RPARAM)->length, 1 );
            return BIOS_NOERR;
    }
    return BIOS_UNSUPPORTED_ERR;
}
