#ifndef __INTERNAL_API_H__
#define __INTERNAL_API_H__

/*!
 * \mainpage BIOS
 * \section ABSTRACT Tv
 * BIOSƂ́ABasic Input Output System̗ŁA{Iȓo͂舵܂B
 * ̏ꍇOSAvP[VvO჌xɈʒuVXe
 * ƂāAn[hEFA̍قz郌CƂĎ܂B
 * 
 * ̃VXéAgccT|[gAŒUARTĂA
 * }CNRg[pVXeΏۂƂBIOSłB
 * 
 * \subsection BOOT N
 * BIOS͎̃V[PXŋNs܂B
 * 
 * - UART̃u[NM`FbNA
 *   u[NԂꍇ̓VO^XN[hŋN
 * - [U[AvP[VNB
 * 
 * <IMG src="boot.png">
 * 
 * Shellɂďڂ́A\ref UIQƂĂB
 * 
 * \subsection INTERRUPT_HANDRING 荞݂̎舵
 * 
 * <IMG src="interrupt.png">
 * 
 * 荞݂̃nhO͂ƕGɂȂ܂A}̂悤ɍs܂B
 * 
 * - ڃ[h
 * ܂ABIOS؊荞݂̃nhOsȂꍇɂ́A[U[
 * AvőSĂ̑s܂BAv̋N͂̏ԂłBA
 * ROM̊荞݃xN^ׂ͂BIOSɌĂ邽߁A荞݃xN^
 * n[hEFA̋@\RAMɍĊ蓖Ăs肷Ȃǂ̓ȑ
 * sȂAAvP[Vڊ荞݂nhO邱
 * ͂ł܂B̂悤ȑsBIOS𑼂̃[hɐؑւ
 * ꍇ́AԂɖ߂ōs悤ɂĂ(Oł)B
 * 
 * 
 * - BIOS荞݃[h
 * BIOS荞݂ۂɁAUARTATIMER̃vbgz[Ԃł̈ႢB邽߁A
 * ̊荞݂ʈBIOStbNAꂼɐݒ肵R[obNĂяoƂł܂B
 * 
 * ̃[hł́AUART, TIMER̐ݒɂāA샂[hω܂B
 * ڍׂɂĂ\ref UI_MODEQƂĂ
 * 
 * \section API
 *
 * \subsection API_CALL APIĂяo
 * API͊{IɉL̃tH[}bgŕ\C̊֐ƂėpӂA
 * BIOS̃o[WςĂĂяo͕ۏ؂̂Ƃ܂B
 * \code
 *    int bios_JeS_[_extension]*( int LPARAM, void *RPARAM )
 * \endcode
 * p[^͐̑p[^ƁA|C^̑p[^ɂč\܂B
 * p[^݂̂KvȏꍇRPARAMɂ0̂Ƃ܂B
 * 
 * p[^͕GȕԂl2葽n߂Ɏg܂B
 * 
 * {Iɂ́A炩ߒ`\̂ĂяoŊmۂėp邱ƂƂA
 * BIOSŃ̊mۂsƂ͂Ȃ̂Ƃ܂B
 * _Åmۂ̂̂ړIƂAPI`ꍇ͂̌ł͂܂B
 * 
 * OIɁA|C^`͈͂ƂmȐƂėp邱Ƃ܂B
 * 
 * Ԃl͊{IintŁA0܂ސ͐I\A̓G[Xe[^XƂ܂B
 * 
 * eAPȈڍׂɊւẮA\ref BIOS_API QƂĂB
 *
 * \subsection API_INTERNAL BIOSAPIĂяo
 * BIOS̓ł́A
 * \code
 *    int _JeS_[_extension]*( ... )
 * \endcode
 * ƂKŃhCo쐬A{IAPI11őΉ̂Ƃ܂B
 *
 * BIOSAPI@\gpꍇ͂̊֐Ăяo܂B
 *
 * APȈڍׂɊւẮA\ref INTERNAL_API QƂĂB
 *
 * \section UI [U[C^[tFCX
 * \subsection UI_MODE [h
 * UIɂ͈ȉ̓샂[h݂܂B
 * 
 * ꂼ̃^XNԂ̑Jڂ\ref bios_shell_mode_set ōs܂B
 * ݂̃[h\ref bios_shell_mode_getŊmF邱Ƃł܂B
 * 
 * - VO^XN[h
 * 荞݋֎~[hœ삷
 * 
 * - }`^XN[h
 * 
 * 
 * - GDB^XN[h
 * 
 * 
 * 
 * \subsection UI_SHELL VF
 * 
*/

#include <drivers.h>

/// \defgroup INTERNAL_API API
/// \brief API
/// BIOSŎgpAPI
//@{

/// \defgroup INTERNAL_API_BIOS API(BIOS)
/// \brief BIOŜɊւAPI
/// BIOS̋N`FbNBzbgX^[gAR[hX^[gȂǂs܂B
//@{
/// APIR[
/// API_NUMɑΉAPIN܂B
int _bios_call_api( int API_NUM, int LPARAM, void *RPALAM );
/// APIڃR[
/// API_NUMɑΉAPI𒼐ڋN܂B
int _bios_call_api_direct( int API_NUM, int LPARAM, void *RPALAM );
/// API_SWIR[
/// API_NUMɑΉAPISWIoRŋN܂B
int _bios_call_api_swi( volatile int API_NUM, volatile int LPARAM, volatile void *RPALAM );
/// [h`FbN
/// Ñ[hؑւ̂߂̃`FbNs܂B
int _bios_boot_check( void );

//@}

/// \defgroup INTERNAL_API_INTERRUPT API(荞)
/// \brief 荞݂𑀍삷
//@{
/// 荞݋
/// \return ݂̊荞ݏ
int _interrupt_enable( void );          
/// 荞݋֎~
/// \return ݂̊荞ݏ
int _interrupt_disable( void );
/// 荞ݕA
/// \param status 荞ݏ
void _interrupt_restore( int status );
/// \brief 荞݂̌ʋ
int _interrupt_enable_num( int number );
/// \brief 荞݂̌ʕs
int _interrupt_disable_num( int number );
/// \brief 荞݂̐ݒ(荞ݏAvCIeB)
int _interrupt_configure( int number, int mode, int priority );
/// \brief 荞݃nh̓o^
int _interrupt_set_handler( int number, bios_interrupt_handler_t handler );
//@}

/// \defgroup UART UARThCo
/// \brief UART̑
/// BIOSł̊荞݂̎gp/sgp͂̃Cŋz܂B
/// [U[AvP[Vł́Aread/write͊荞݂̎gp/sgpɂ炸
/// M܂ő҂܂BR[obNgp邩A
/// BIOSgpȂUART𑀍삷Kv܂B
//@{
/// UART
/// \param port |[gԍ
/// \param params p[^BNULLnƃftHgݒB
int _uart_init( int port, bios_uart_param_t *params );

/// \brief UART̊荞݊mF
int _uart_interrupt_enabled( int port );
/// \brief UART̊荞݋
int _uart_interrupt_enable( int port );
/// \brief UART̊荞ݕs
/// 荞ݑML[ɕ񂪂ꍇׂ͂đMĂؑւ܂B
int _uart_interrupt_disable( int port );
/// \brief ^CAEgw
int _uart_set_timeout( int port, int read_timeout, int write_timeout );

/// \defgroup INTERNAL_API_UART_LOWLEVEL ჌xUART
/// \brief ჌xUARTs܂
/// ̊֐͓APÎݎQƂ܂
/// 
//@{
/// \brief 荞݃nh`
typedef void (*bios_uart_handler_t)(int port);

int _uart_rx_ready( int port );
int _uart_tx_ready( int port );
int _uart_getc( int port );
int _uart_putc( int port, unsigned char c );

/// \brief UARTM荞݊mF
int _uart_send_interrupt_enabled( int port );
/// \brief UARTM荞݋
int _uart_send_interrupt_enable( int port );
/// \brief UARTM荞݃nho^
int _uart_send_interrupt_set_handler( int port, bios_uart_callback_t handler );
/// \brief UARTM荞ݕs
int _uart_send_interrupt_disable( int port );

/// \brief UARTM荞݊mF
int _uart_recv_interrupt_enabled( int port );
/// \brief UARTM荞݋
int _uart_recv_interrupt_enable( int port );
/// \brief UARTM荞݃nho^
int _uart_recv_interrupt_set_handler( int port, bios_uart_callback_t handler );
/// \brief UARTM荞ݕs
int _uart_recv_interrupt_disable( int port );

//@}
/// UARTlengthoCgM܂(荞ݕsgp)
/// M^CAEg0̏ꍇ͎M܂ő҂܂B
int _uart_read_noi( int port, char *str, int length );
/// UARTlengthoCgM܂(荞ݕsgp)
/// M^CAEg0̏ꍇ͑M܂ő҂܂B
int _uart_write_noi( int port, char *str, int length );

/// UARTlengthoCgM܂(荞ݎgp)
/// M^CAEg0̏ꍇ͎M܂ő҂܂B
int _uart_read_i( int port, char *str, int length );
/// UARTlengthoCgM܂(荞ݎgp)
/// M^CAEg0̏ꍇ͑M܂ő҂܂B
int _uart_write_i( int port, char *str, int length );

//@}


/// \defgroup INTERNAL_API_TIMER API(TIMER)
/// \brief TIMEȒ
//@{
/// TIMEȐ
int _timer_init( void );
/// TIMERR[obNo^
int _timer_set_callback( bios_timer_callback_t callback );
//@}

/// \defgroup INTERNAL_API_FLASH API(FLASH)
/// \brief FLASHROM̑
//@{
/// FLASH
void  _flash_write( void *address, void *data, int length, int verbose );
/// FLASH(݌Au[g)
void  _flash_write_bios( void *address, void *data, int length );
//@}


/// \defgroup SHELL VF
///
//@{
/// \brief VO^XNVF̋N
void shell( char *prompt );

/// \brief SHELL̃[hmF
bios_shell_mode_t _shell_mode_get( void );

/// \brief SHELL̃[hݒ
void _shell_mode_set( bios_shell_mode_t mode, char *prompt );

/// \brief SHELLɃR}hǉ
void _shell_command_add( shell_command_list_t *command_table );

//@}

//@}

#endif //__INTERNAL_API_H__
