#include <string.h>
#include <bios_api.h>
#include <plathome.h>

#include <shell/shell_uart.h>
#include <shell/shell_string.h>

#include <shell/command.h>

static int test( int argc, char **argv );

static shell_command_list_t const internal_command_table[] =
{
    { "test",      test,      "eXgR}h" },
    { 0,0,0 }
};

static int help( int argc, char **argv )
{
    int i = 0;
    shell_print( "extR}h\t\n" );
    while ( internal_command_table[i].name )
    {
        shell_print( "ext " );
        shell_print( internal_command_table[i].name );
        shell_print( "\t\t" );
        shell_print( internal_command_table[i].help );
        shell_print( "\n" );
        i++;
    }
    return BIOS_NOERR;
}

static int test( int argc, char **argv )
{
    shell_print( "test command \n" );
    shell_print( "(10i) " );
    shell_print( shell_l2dec( 10, sizeof( int ) << 1) );
    shell_print( "\n" );

    shell_print( "(16i) " );
    shell_print( shell_ul2hex( 10, sizeof( int ) << 1) );
    shell_print( "\n" );
    return BIOS_NOERR;
}

int exec_extra_command( int argc, char **argv )
{
    int rval;
    rval = exec_command( (shell_command_list_t *)internal_command_table, argc, argv );
    if ( rval == BIOS_SHELL_INVALID_COMMAND )
    {
        help(0, 0);
        rval = BIOS_SHELL_INVALID_ARGS;
    }
    return rval;
}
