#ifndef __PLATHOME_H__
#define __PLATHOME_H__

const unsigned char *Version( void );

typedef unsigned char   byte;
typedef unsigned short  hword;
typedef unsigned long   word;
typedef unsigned long   addr_t;

#define UART_CHECK_COUNT_1MS            (3146)
#define UART_QUEUE_SIZE                 (4)
#define UART_NUM_OF_PORTS               (3)

#define SHELL_UART_PORT (1)

#define SHELL_COMMANDLINE_LENGTH        (32)
#define SHELL_ARGUMENT_NUM              (16)
#define SHELL_ARGUMENT_LENGTH           (16)
#define SHELL_HISTORY_NUM               (5)

#define FLASH_SYSTEM_START              (0)
#define FLASH_SYSTEM_MAX_SIZE           (0x4000)
#define FLASH_TEMP_BUFFER_START         (0x00400000)

#define FLASH_USER_START                (0x4000)
#define FLASH_USER_ENTRY                (0x4000)
#define FLASH_USER_MAX_SIZE             (0x3c000)

typedef enum {
    INTERRUPT_AKI_H8_3069_RESET,
    INTERRUPT_AKI_H8_3069_RESERVED_1,
    INTERRUPT_AKI_H8_3069_RESERVED_2,
    INTERRUPT_AKI_H8_3069_RESERVED_3,
    INTERRUPT_AKI_H8_3069_RESERVED_4,
    INTERRUPT_AKI_H8_3069_RESERVED_5,
    INTERRUPT_AKI_H8_3069_RESERVED_6,
    INTERRUPT_AKI_H8_3069_NMI,
    INTERRUPT_AKI_H8_3069_TRAP0,
    INTERRUPT_AKI_H8_3069_TRAP1,
    INTERRUPT_AKI_H8_3069_TRAP2,
    INTERRUPT_AKI_H8_3069_TRAP3,
    INTERRUPT_AKI_H8_3069_IRQ0,
    INTERRUPT_AKI_H8_3069_IRQ1,
    INTERRUPT_AKI_H8_3069_IRQ2,
    INTERRUPT_AKI_H8_3069_IRQ3,
    INTERRUPT_AKI_H8_3069_IRQ4,
    INTERRUPT_AKI_H8_3069_IRQ5,
    INTERRUPT_AKI_H8_3069_RESERVED_18,
    INTERRUPT_AKI_H8_3069_RESERVED_19,
    INTERRUPT_AKI_H8_3069_WOVI,
    INTERRUPT_AKI_H8_3069_CMI,
    INTERRUPT_AKI_H8_3069_RESERVED_22,
    INTERRUPT_AKI_H8_3069_ADI,
    INTERRUPT_AKI_H8_3069_IMIA0,
    INTERRUPT_AKI_H8_3069_IMIB0,
    INTERRUPT_AKI_H8_3069_OVI0,
    INTERRUPT_AKI_H8_3069_RESERVED_27,
    INTERRUPT_AKI_H8_3069_IMIA1,
    INTERRUPT_AKI_H8_3069_IMIB1,
    INTERRUPT_AKI_H8_3069_OVI1,
    INTERRUPT_AKI_H8_3069_RESERVED_31,
    INTERRUPT_AKI_H8_3069_IMIA2,
    INTERRUPT_AKI_H8_3069_IMIB2,
    INTERRUPT_AKI_H8_3069_OVI2,
    INTERRUPT_AKI_H8_3069_RESERVED_35,
    INTERRUPT_AKI_H8_3069_CMIA0,
    INTERRUPT_AKI_H8_3069_CMIB0,
    INTERRUPT_AKI_H8_3069_CMIAB1,
    INTERRUPT_AKI_H8_3069_TOVI01,
    INTERRUPT_AKI_H8_3069_CMIA2,
    INTERRUPT_AKI_H8_3069_CMIB2,
    INTERRUPT_AKI_H8_3069_CMIAB3,
    INTERRUPT_AKI_H8_3069_TOVI23,
    INTERRUPT_AKI_H8_3069_DEND0A,
    INTERRUPT_AKI_H8_3069_DEND0B,
    INTERRUPT_AKI_H8_3069_DEND1A,
    INTERRUPT_AKI_H8_3069_DEND1B,
    INTERRUPT_AKI_H8_3069_RESERVED_48,
    INTERRUPT_AKI_H8_3069_RESERVED_49,
    INTERRUPT_AKI_H8_3069_RESERVED_50,
    INTERRUPT_AKI_H8_3069_RESERVED_51,
    INTERRUPT_AKI_H8_3069_ERI0,
    INTERRUPT_AKI_H8_3069_RXI0,
    INTERRUPT_AKI_H8_3069_TXI0,
    INTERRUPT_AKI_H8_3069_TEI0,
    INTERRUPT_AKI_H8_3069_ERI1,
    INTERRUPT_AKI_H8_3069_RXI1,
    INTERRUPT_AKI_H8_3069_TXI1,
    INTERRUPT_AKI_H8_3069_TEI1,
    INTERRUPT_AKI_H8_3069_ERI2,
    INTERRUPT_AKI_H8_3069_RXI2,
    INTERRUPT_AKI_H8_3069_TXI2,
    INTERRUPT_AKI_H8_3069_TEI2,
    AKI_H8_3069_NUM_OF_INTERRUPT
} AKI_H8_3069_INTERRUPT_NUMBER;


#endif //__PLATHOME_H__
