#ifndef __H8_3069F_H__
#define __H8_3069F_H__

#define REGISTER( base, reg ) (*(volatile unsigned char *)(base + reg))

// I/O|[g
#define       P1DDR_P10DDR 0x01
#define       P1DDR_P11DDR 0x02
#define       P1DDR_P12DDR 0x04
#define       P1DDR_P13DDR 0x08
#define       P1DDR_P14DDR 0x10
#define       P1DDR_P15DDR 0x20
#define       P1DDR_P16DDR 0x40
#define       P1DDR_P17DDR 0x80
#define       P2DDR_P20DDR 0x01
#define       P2DDR_P21DDR 0x02
#define       P2DDR_P22DDR 0x04
#define       P2DDR_P23DDR 0x08
#define       P2DDR_P24DDR 0x10
#define       P2DDR_P25DDR 0x20
#define       P2DDR_P26DDR 0x40
#define       P2DDR_P27DDR 0x80
#define       P3DDR_P30DDR 0x01
#define       P3DDR_P31DDR 0x02
#define       P3DDR_P32DDR 0x04
#define       P3DDR_P33DDR 0x08
#define       P3DDR_P34DDR 0x10
#define       P3DDR_P35DDR 0x20
#define       P3DDR_P36DDR 0x40
#define       P3DDR_P37DDR 0x80
#define       P4DDR_P40DDR 0x01
#define       P4DDR_P41DDR 0x02
#define       P4DDR_P42DDR 0x04
#define       P4DDR_P43DDR 0x08
#define       P4DDR_P44DDR 0x10
#define       P4DDR_P45DDR 0x20
#define       P4DDR_P46DDR 0x40
#define       P4DDR_P47DDR 0x80
#define       P5DDR_P50DDR 0x01
#define       P5DDR_P51DDR 0x02
#define       P5DDR_P52DDR 0x04
#define       P5DDR_P53DDR 0x08
#define       P6DDR_P60DDR 0x01
#define       P6DDR_P61DDR 0x02
#define       P6DDR_P62DDR 0x04
#define       P6DDR_P63DDR 0x08
#define       P6DDR_P64DDR 0x10
#define       P6DDR_P65DDR 0x20
#define       P6DDR_P66DDR 0x40
#define       P8DDR_P80DDR 0x01
#define       P8DDR_P81DDR 0x02
#define       P8DDR_P82DDR 0x04
#define       P8DDR_P83DDR 0x08
#define       P8DDR_P84DDR 0x10
#define       P9DDR_P90DDR 0x01
#define       P9DDR_P91DDR 0x02
#define       P9DDR_P92DDR 0x04
#define       P9DDR_P93DDR 0x08
#define       P9DDR_P94DDR 0x10
#define       P9DDR_P95DDR 0x20
#define       PADDR_PA0DDR 0x01
#define       PADDR_PA1DDR 0x02
#define       PADDR_PA2DDR 0x04
#define       PADDR_PA3DDR 0x08
#define       PADDR_PA4DDR 0x10
#define       PADDR_PA5DDR 0x20
#define       PADDR_PA6DDR 0x40
#define       PADDR_PA7DDR 0x80
#define       PBDDR_PB0DDR 0x01
#define       PBDDR_PB1DDR 0x02
#define       PBDDR_PB2DDR 0x04
#define       PBDDR_PB3DDR 0x08
#define       PBDDR_PB4DDR 0x10
#define       PBDDR_PB5DDR 0x20
#define       PBDDR_PB6DDR 0x40
#define       PBDDR_PB7DDR 0x80
#define       P2PCR_P20PCR 0x01
#define       P2PCR_P21PCR 0x02
#define       P2PCR_P22PCR 0x04
#define       P2PCR_P23PCR 0x08
#define       P2PCR_P24PCR 0x10
#define       P2PCR_P25PCR 0x20
#define       P2PCR_P26PCR 0x40
#define       P2PCR_P27PCR 0x80
#define       P4PCR_P40PCR 0x01
#define       P4PCR_P41PCR 0x02
#define       P4PCR_P42PCR 0x04
#define       P4PCR_P43PCR 0x08
#define       P4PCR_P44PCR 0x10
#define       P4PCR_P45PCR 0x20
#define       P4PCR_P46PCR 0x40
#define       P4PCR_P47PCR 0x80
#define       P5PCR_P50PCR 0x01
#define       P5PCR_P51PCR 0x02
#define       P5PCR_P52PCR 0x04
#define       P5PCR_P53PCR 0x08
#define           P1DR_P10 0x01
#define           P1DR_P11 0x02
#define           P1DR_P12 0x04
#define           P1DR_P13 0x08
#define           P1DR_P14 0x10
#define           P1DR_P15 0x20
#define           P1DR_P16 0x40
#define           P1DR_P17 0x80
#define           P2DR_P20 0x01
#define           P2DR_P21 0x02
#define           P2DR_P22 0x04
#define           P2DR_P23 0x08
#define           P2DR_P24 0x10
#define           P2DR_P25 0x20
#define           P2DR_P26 0x40
#define           P2DR_P27 0x80
#define           P3DR_P30 0x01
#define           P3DR_P31 0x02
#define           P3DR_P32 0x04
#define           P3DR_P33 0x08
#define           P3DR_P34 0x10
#define           P3DR_P35 0x20
#define           P3DR_P36 0x40
#define           P3DR_P37 0x80
#define           P4DR_P40 0x01
#define           P4DR_P41 0x02
#define           P4DR_P42 0x04
#define           P4DR_P43 0x08
#define           P4DR_P44 0x10
#define           P4DR_P45 0x20
#define           P4DR_P46 0x40
#define           P4DR_P47 0x80
#define           P5DR_P50 0x01
#define           P5DR_P51 0x02
#define           P5DR_P52 0x04
#define           P5DR_P53 0x08
#define           P6DR_P60 0x01
#define           P6DR_P61 0x02
#define           P6DR_P62 0x04
#define           P6DR_P63 0x08
#define           P6DR_P64 0x10
#define           P6DR_P65 0x20
#define           P6DR_P66 0x40
#define           P6DR_P67 0x80
#define           P7DR_P70 0x01
#define           P7DR_P71 0x02
#define           P7DR_P72 0x04
#define           P7DR_P73 0x08
#define           P7DR_P74 0x10
#define           P7DR_P75 0x20
#define           P7DR_P76 0x40
#define           P7DR_P77 0x80
#define           P8DR_P80 0x01
#define           P8DR_P81 0x02
#define           P8DR_P82 0x04
#define           P8DR_P83 0x08
#define           P8DR_P84 0x10
#define           P9DR_P90 0x01
#define           P9DR_P91 0x02
#define           P9DR_P92 0x04
#define           P9DR_P93 0x08
#define           P9DR_P94 0x10
#define           P9DR_P95 0x20
#define           PADR_PA0 0x01
#define           PADR_PA1 0x02
#define           PADR_PA2 0x04
#define           PADR_PA3 0x08
#define           PADR_PA4 0x10
#define           PADR_PA5 0x20
#define           PADR_PA6 0x40
#define           PADR_PA7 0x80
#define           PBDR_PB0 0x01
#define           PBDR_PB1 0x02
#define           PBDR_PB2 0x04
#define           PBDR_PB3 0x08
#define           PBDR_PB4 0x10
#define           PBDR_PB5 0x20
#define           PBDR_PB6 0x40
#define           PBDR_PB7 0x80
#define    P1DDR (*((volatile unsigned  char *)(0xFEE000)))  // I/O|[g 1
#define    P2DDR (*((volatile unsigned  char *)(0xFEE001)))  // I/O|[g 2
#define    P3DDR (*((volatile unsigned  char *)(0xFEE002)))  // I/O|[g 3
#define    P4DDR (*((volatile unsigned  char *)(0xFEE003)))  // I/O|[g 4
#define    P5DDR (*((volatile unsigned  char *)(0xFEE004)))  // I/O|[g 5
#define    P6DDR (*((volatile unsigned  char *)(0xFEE005)))  // I/O|[g 6
#define    P8DDR (*((volatile unsigned  char *)(0xFEE007)))  // I/O|[g 8
#define    P9DDR (*((volatile unsigned  char *)(0xFEE008)))  // I/O|[g 9
#define    PADDR (*((volatile unsigned  char *)(0xFEE009)))  // I/O|[g A
#define    PBDDR (*((volatile unsigned  char *)(0xFEE00A)))  // I/O|[g B
#define    P2PCR (*((volatile unsigned  char *)(0xFEE03C)))  // I/O|[g Q
#define    P4PCR (*((volatile unsigned  char *)(0xFEE03E)))  // I/O|[g S
#define    P5PCR (*((volatile unsigned  char *)(0xFEE03F)))  // I/O|[g T
#define     P1DR (*((volatile unsigned  char *)(0xFFFFD0)))  // I/O|[g 1
#define     P2DR (*((volatile unsigned  char *)(0xFFFFD1)))  // I/O|[g 2
#define     P3DR (*((volatile unsigned  char *)(0xFFFFD2)))  // I/O|[g 3
#define     P4DR (*((volatile unsigned  char *)(0xFFFFD3)))  // I/O|[g 4
#define     P5DR (*((volatile unsigned  char *)(0xFFFFD4)))  // I/O|[g 5
#define     P6DR (*((volatile unsigned  char *)(0xFFFFD5)))  // I/O|[g 6
#define     P7DR (*((volatile unsigned  char *)(0xFFFFD6)))  // I/O|[g 7
#define     P8DR (*((volatile unsigned  char *)(0xFFFFD7)))  // I/O|[g 8
#define     P9DR (*((volatile unsigned  char *)(0xFFFFD8)))  // I/O|[g 9
#define     PADR (*((volatile unsigned  char *)(0xFFFFD9)))  // I/O|[g A
#define     PBDR (*((volatile unsigned  char *)(0xFFFFDA)))  // I/O|[g B

// VXe
#define          MDCR_MDS0 0x01
#define          MDCR_MDS1 0x02
#define          MDCR_MDS2 0x04
#define         SYSCR_RAME 0x01
#define         SYSCR_SSOE 0x02
#define        SYSCR_NMIEG 0x04
#define           SYSCR_UE 0x08
#define         SYSCR_STS0 0x10
#define         SYSCR_STS1 0x20
#define         SYSCR_STS2 0x40
#define         SYSCR_SSBY 0x80
#define         DIVCR_DIV0 0x01
#define         DIVCR_DIV1 0x02
#define      MSTCRH_MSTPH0 0x01
#define      MSTCRH_MSTPH1 0x02
#define      MSTCRH_MSTPH2 0x04
#define       MSTCRH_PSTOP 0x80
#define      MSTCRL_MSTPL0 0x01
#define      MSTCRL_MSTPL2 0x04
#define      MSTCRL_MSTPL3 0x08
#define      MSTCRL_MSTPL4 0x10
#define      MSTCRL_MSTPL5 0x20
#define      MSTCRL_MSTPL7 0x80
#define     MDCR (*((volatile unsigned  char *)(0xFEE011)))  // VXe
#define    SYSCR (*((volatile unsigned  char *)(0xFEE012)))  // VXe
#define    DIVCR (*((volatile unsigned  char *)(0xFEE01B)))  // VXe
#define   MSTCRH (*((volatile unsigned  char *)(0xFEE01C)))  // VXe
#define   MSTCRL (*((volatile unsigned  char *)(0xFEE01D)))  // VXe

// oXRg[
#define          BRCR_BRLE 0x01
#define          BRCR_A20E 0x10
#define          BRCR_A21E 0x20
#define          BRCR_A22E 0x40
#define          BRCR_A23E 0x80
#define       ADRCR_ADRCTL 0x01
#define          CSCR_CS4E 0x10
#define          CSCR_CS5E 0x20
#define          CSCR_CS6E 0x40
#define          CSCR_CS7E 0x80
#define         ABWCR_ABW0 0x01
#define         ABWCR_ABW1 0x02
#define         ABWCR_ABW2 0x04
#define         ABWCR_ABW3 0x08
#define         ABWCR_ABW4 0x10
#define         ABWCR_ABW5 0x20
#define         ABWCR_ABW6 0x40
#define         ABWCR_ABW7 0x80
#define         ASTCR_AST0 0x01
#define         ASTCR_AST1 0x02
#define         ASTCR_AST2 0x04
#define         ASTCR_AST3 0x08
#define         ASTCR_AST4 0x10
#define         ASTCR_AST5 0x20
#define         ASTCR_AST6 0x40
#define         ASTCR_AST7 0x80
#define           WCRH_W40 0x01
#define           WCRH_W41 0x02
#define           WCRH_W50 0x04
#define           WCRH_W51 0x08
#define           WCRH_W60 0x10
#define           WCRH_W61 0x20
#define           WCRH_W70 0x40
#define           WCRH_W71 0x80
#define           WCRL_W00 0x01
#define           WCRL_W01 0x02
#define           WCRL_W10 0x04
#define           WCRL_W11 0x08
#define           WCRL_W20 0x10
#define           WCRL_W21 0x20
#define           WCRL_W30 0x40
#define           WCRL_W31 0x80
#define          BCR_WAITE 0x01
#define           BCR_RDEA 0x02
#define         BCR_BRSTS0 0x08
#define         BCR_BRSTS1 0x10
#define          BCR_BROME 0x20
#define          BCR_ICIS0 0x40
#define          BCR_ICIS1 0x80
#define     BRCR (*((volatile unsigned  char *)(0xFEE013)))  // oXRg[
#define    ADRCR (*((volatile unsigned  char *)(0xFEE01E)))  // oXRg[
#define     CSCR (*((volatile unsigned  char *)(0xFEE01F)))  // oXRg[
#define    ABWCR (*((volatile unsigned  char *)(0xFEE020)))  // oXRg[
#define    ASTCR (*((volatile unsigned  char *)(0xFEE021)))  // oXRg[
#define     WCRH (*((volatile unsigned  char *)(0xFEE022)))  // oXRg[
#define     WCRL (*((volatile unsigned  char *)(0xFEE023)))  // oXRg[
#define      BCR (*((volatile unsigned  char *)(0xFEE024)))  // oXRg[

// 荞݃Rg[
#define        ISCR_IRQ0SC 0x01
#define        ISCR_IRQ1SC 0x02
#define        ISCR_IRQ2SC 0x04
#define        ISCR_IRQ3SC 0x08
#define        ISCR_IRQ4SC 0x10
#define        ISCR_IRQ5SC 0x20
#define          IER_IRQ0E 0x01
#define          IER_IRQ1E 0x02
#define          IER_IRQ2E 0x04
#define          IER_IRQ3E 0x08
#define          IER_IRQ4E 0x10
#define          IER_IRQ5E 0x20
#define          ISR_IRQ0F 0x01
#define          ISR_IRQ1F 0x02
#define          ISR_IRQ2F 0x04
#define          ISR_IRQ3F 0x08
#define          ISR_IRQ4F 0x10
#define          ISR_IRQ5F 0x20
#define         IPRA_IPRA0 0x01
#define         IPRA_IPRA1 0x02
#define         IPRA_IPRA2 0x04
#define         IPRA_IPRA3 0x08
#define         IPRA_IPRA4 0x10
#define         IPRA_IPRA5 0x20
#define         IPRA_IPRA6 0x40
#define         IPRA_IPRA7 0x80
#define         IPRB_IPRB1 0x02
#define         IPRB_IPRB2 0x04
#define         IPRB_IPRB3 0x08
#define         IPRB_IPRB5 0x20
#define         IPRB_IPRB6 0x40
#define         IPRB_IPRB7 0x80
#define     ISCR (*((volatile unsigned  char *)(0xFEE014)))  // 荞݃Rg[
#define      IER (*((volatile unsigned  char *)(0xFEE015)))  // 荞݃Rg[
#define      ISR (*((volatile unsigned  char *)(0xFEE016)))  // 荞݃Rg[
#define     IPRA (*((volatile unsigned  char *)(0xFEE018)))  // 荞݃Rg[
#define     IPRB (*((volatile unsigned  char *)(0xFEE019)))  // 荞݃Rg[

// DAϊ
#define       DASTCR_DASTE 0x01
#define           DACR_DAE 0x20
#define         DACR_DAOE0 0x40
#define         DACR_DAOE1 0x80
#define   DASTCR (*((volatile unsigned  char *)(0xFEE01A)))  // DAϊ
#define    DADR0 (*((volatile unsigned  char *)(0xFFFF9C)))  // DAϊ
#define    DADR1 (*((volatile unsigned  char *)(0xFFFF9D)))  // DAϊ
#define     DACR (*((volatile unsigned  char *)(0xFFFF9E)))  // DAϊ

// DRAMC^tF[X
#define        DRCRA_RFSHE 0x01
#define        DRCRA_SRFMD 0x02
#define          DRCRA_RDM 0x04
#define           DRCRA_BE 0x08
#define        DRCRA_DRAS0 0x20
#define        DRCRA_DRAS1 0x40
#define        DRCRA_DRAS2 0x80
#define          DRCRB_RLW 0x01
#define          DRCRB_RCW 0x02
#define          DRCRB_TPC 0x04
#define        DRCRB_RCYCE 0x10
#define         DRCRB_CSEL 0x20
#define         DRCRB_MXC0 0x40
#define         DRCRB_MXC1 0x80
#define        RTMCSR_CKS0 0x08
#define        RTMCSR_CKS1 0x10
#define        RTMCSR_CKS2 0x20
#define        RTMCSR_CMIE 0x40
#define         RTMCSR_CMF 0x80
#define    DRCRA (*((volatile unsigned  char *)(0xFEE026)))  // DRAMC^tF[X
#define    DRCRB (*((volatile unsigned  char *)(0xFEE027)))  // DRAMC^tF[X
#define   RTMCSR (*((volatile unsigned  char *)(0xFEE028)))  // DRAMC^tF[X
#define    RTCNT (*((volatile unsigned  char *)(0xFEE029)))  // DRAMC^tF[X
#define    RTCOR (*((volatile unsigned  char *)(0xFEE02A)))  // DRAMC^tF[X

// tbV
#define         RAMCR_RAM0 0x01
#define         RAMCR_RAM1 0x02
#define         RAMCR_RAM2 0x04
#define         RAMCR_RAMS 0x08
#define           FCCS_SCO 0x01
#define          FCCS_FLER 0x10
#define           FCCS_FWE 0x80
#define          FPCS_PPVS 0x01
#define          FECS_EPVB 0x01
#define            FKEY_K0 0x01
#define            FKEY_K1 0x02
#define            FKEY_K2 0x04
#define            FKEY_K3 0x08
#define            FKEY_K4 0x10
#define            FKEY_K5 0x20
#define            FKEY_K6 0x40
#define            FKEY_K7 0x80
#define          FMATS_MS0 0x01
#define          FMATS_MS1 0x02
#define          FMATS_MS2 0x04
#define          FMATS_MS3 0x08
#define          FMATS_MS4 0x10
#define          FMATS_MS5 0x20
#define          FMATS_MS6 0x40
#define          FMATS_MS7 0x80
#define       FVACR_FVSEL0 0x01
#define       FVACR_FVSEL1 0x02
#define       FVACR_FVSEL2 0x04
#define       FVACR_FVSEL3 0x08
#define       FVACR_FVCHGE 0x80
#define    RAMCR (*((volatile unsigned  char *)(0xFEE077)))  // tbV
#define     FCCS (*((volatile unsigned  char *)(0xFEE0B0)))  // tbV
#define     FPCS (*((volatile unsigned  char *)(0xFEE0B1)))  // tbV
#define     FECS (*((volatile unsigned  char *)(0xFEE0B2)))  // tbV
#define     FKEY (*((volatile unsigned  char *)(0xFEE0B4)))  // tbV
#define    FMATS (*((volatile unsigned  char *)(0xFEE0B5)))  // tbV
#define    FTDAR (*((volatile unsigned  char *)(0xFEE0B6)))  // tbV
#define    FVACR (*((volatile unsigned  char *)(0xFEE0B7)))  // tbV
#define   FVADRR (*((volatile unsigned  char *)(0xFEE0B8)))  // tbV
#define   FVADRE (*((volatile unsigned  char *)(0xFEE0B9)))  // tbV
#define   FVADRH (*((volatile unsigned  char *)(0xFEE0BA)))  // tbV
#define   FVADRL (*((volatile unsigned  char *)(0xFEE0BB)))  // tbV

// DMAC
#define       DTCR0A_DTS0A 0x01
#define       DTCR0A_DTS1A 0x02
#define       DTCR0A_DTS2A 0x04
#define        DTCR0A_DTIE 0x08
#define       DTCR0A_SAIDE 0x10
#define        DTCR0A_SAID 0x20
#define        DTCR0A_DTSZ 0x40
#define         DTCR0A_DTE 0x80
#define       DTCR0B_DTS0B 0x01
#define       DTCR0B_DTS1B 0x02
#define       DTCR0B_DTS2B 0x04
#define         DTCR0B_TMS 0x08
#define       DTCR0B_DAIDE 0x10
#define        DTCR0B_DAID 0x20
#define        DTCR0B_DTME 0x80
#define       DTCR1A_DTS0A 0x01
#define       DTCR1A_DTS1A 0x02
#define       DTCR1A_DTS2A 0x04
#define        DTCR1A_DTIE 0x08
#define       DTCR1A_SAIDE 0x10
#define        DTCR1A_SAID 0x20
#define        DTCR1A_DTSZ 0x40
#define         DTCR1A_DTE 0x80
#define       DTCR1B_DTS0B 0x01
#define       DTCR1B_DTS1B 0x02
#define       DTCR1B_DTS2B 0x04
#define         DTCR1B_TMS 0x08
#define       DTCR1B_DAIDE 0x10
#define        DTCR1B_DAID 0x20
#define        DTCR1B_DTME 0x80
#define   MAR0AR (*((volatile unsigned  char *)(0xFFFF20)))  // DMAC `l0A
#define   MAR0AE (*((volatile unsigned  char *)(0xFFFF21)))  // DMAC `l0A
#define   MAR0AH (*((volatile unsigned  char *)(0xFFFF22)))  // DMAC `l0A
#define   MAR0AL (*((volatile unsigned  char *)(0xFFFF23)))  // DMAC `l0A
#define  ETCR0AH (*((volatile unsigned  char *)(0xFFFF24)))  // DMAC `l0A
#define  ETCR0AL (*((volatile unsigned  char *)(0xFFFF25)))  // DMAC `l0A
#define   IOAR0A (*((volatile unsigned  char *)(0xFFFF26)))  // DMAC `l0A
#define   DTCR0A (*((volatile unsigned  char *)(0xFFFF27)))  // DMAC `l0A
#define   MAR0BR (*((volatile unsigned  char *)(0xFFFF28)))  // DMAC `l0B
#define   MAR0BE (*((volatile unsigned  char *)(0xFFFF29)))  // DMAC `l0B
#define   MAR0BH (*((volatile unsigned  char *)(0xFFFF2A)))  // DMAC `l0B
#define   MAR0BL (*((volatile unsigned  char *)(0xFFFF2B)))  // DMAC `l0B
#define  ETCR0BH (*((volatile unsigned  char *)(0xFFFF2C)))  // DMAC `l0B
#define  ETCR0BL (*((volatile unsigned  char *)(0xFFFF2D)))  // DMAC `l0B
#define   IOAR0B (*((volatile unsigned  char *)(0xFFFF2E)))  // DMAC `l0B
#define   DTCR0B (*((volatile unsigned  char *)(0xFFFF2F)))  // DMAC `l0B
#define   MAR1AR (*((volatile unsigned  char *)(0xFFFF30)))  // DMAC `l1A
#define   MAR1AE (*((volatile unsigned  char *)(0xFFFF31)))  // DMAC `l1A
#define   MAR1AH (*((volatile unsigned  char *)(0xFFFF32)))  // DMAC `l1A
#define   MAR1AL (*((volatile unsigned  char *)(0xFFFF33)))  // DMAC `l1A
#define  ETCR1AH (*((volatile unsigned  char *)(0xFFFF34)))  // DMAC `l1A
#define  ETCR1AL (*((volatile unsigned  char *)(0xFFFF35)))  // DMAC `l1A
#define   IOAR1A (*((volatile unsigned  char *)(0xFFFF36)))  // DMAC `l1A
#define   DTCR1A (*((volatile unsigned  char *)(0xFFFF37)))  // DMAC `l1A
#define   MAR1BR (*((volatile unsigned  char *)(0xFFFF38)))  // DMAC `l1B
#define   MAR1BE (*((volatile unsigned  char *)(0xFFFF39)))  // DMAC `l1B
#define   MAR1BH (*((volatile unsigned  char *)(0xFFFF3A)))  // DMAC `l1B
#define   MAR1BL (*((volatile unsigned  char *)(0xFFFF3B)))  // DMAC `l1B
#define  ETCR1BH (*((volatile unsigned  char *)(0xFFFF3C)))  // DMAC `l1B
#define  ETCR1BL (*((volatile unsigned  char *)(0xFFFF3D)))  // DMAC `l1B
#define   IOAR1B (*((volatile unsigned  char *)(0xFFFF3E)))  // DMAC `l1B
#define   DTCR1B (*((volatile unsigned  char *)(0xFFFF3F)))  // DMAC `l1B

// 16rbg^C}
#define          TSTR_STR0 0x01
#define          TSTR_STR1 0x02
#define          TSTR_STR2 0x04
#define         TSNC_SYNC0 0x01
#define         TSNC_SYNC1 0x02
#define         TSNC_SYNC2 0x04
#define          TMDR_PWM0 0x01
#define          TMDR_PWM1 0x02
#define          TMDR_PWM2 0x04
#define          TMDR_FDIR 0x20
#define           TMDR_MDF 0x40
#define          TOLR_TOA0 0x01
#define          TOLR_TOB0 0x02
#define          TOLR_TOA1 0x04
#define          TOLR_TOB1 0x08
#define          TOLR_TOA2 0x10
#define          TOLR_TOB2 0x20
#define        TISRA_IMFA0 0x01
#define        TISRA_IMFA1 0x02
#define        TISRA_IMFA2 0x04
#define       TISRA_IMIEA0 0x10
#define       TISRA_IMIEA1 0x20
#define       TISRA_IMIEA2 0x40
#define        TISRB_IMFB0 0x01
#define        TISRB_IMFB1 0x02
#define        TISRB_IMFB2 0x04
#define       TISRB_IMIEB0 0x10
#define       TISRB_IMIEB1 0x20
#define       TISRB_IMIEB2 0x40
#define         TISRC_OVF0 0x01
#define         TISRC_OVF1 0x02
#define         TISRC_OVF2 0x04
#define        TISRC_OVIE0 0x10
#define        TISRC_OVIE1 0x20
#define        TISRC_OVIE2 0x40
#define       T16CR0_TPSC0 0x01
#define       T16CR0_TPSC1 0x02
#define       T16CR0_TPSC2 0x04
#define       T16CR0_CKEG0 0x08
#define       T16CR0_CKEG1 0x10
#define       T16CR0_CCLR0 0x20
#define       T16CR0_CCLR1 0x40
#define         TIOR0_IOA0 0x01
#define         TIOR0_IOA1 0x02
#define         TIOR0_IOA2 0x04
#define         TIOR0_IOB0 0x10
#define         TIOR0_IOB1 0x20
#define         TIOR0_IOB2 0x40
#define       T16CR1_TPSC0 0x01
#define       T16CR1_TPSC1 0x02
#define       T16CR1_TPSC2 0x04
#define       T16CR1_CKEG0 0x08
#define       T16CR1_CKEG1 0x10
#define       T16CR1_CCLR0 0x20
#define       T16CR1_CCLR1 0x40
#define         TIOR1_IOA0 0x01
#define         TIOR1_IOA1 0x02
#define         TIOR1_IOA2 0x04
#define         TIOR1_IOB0 0x10
#define         TIOR1_IOB1 0x20
#define         TIOR1_IOB2 0x40
#define       T16CR2_TPSC0 0x01
#define       T16CR2_TPSC1 0x02
#define       T16CR2_TPSC2 0x04
#define       T16CR2_CKEG0 0x08
#define       T16CR2_CKEG1 0x10
#define       T16CR2_CCLR0 0x20
#define       T16CR2_CCLR1 0x40
#define         TIOR2_IOA0 0x01
#define         TIOR2_IOA1 0x02
#define         TIOR2_IOA2 0x04
#define         TIOR2_IOB0 0x10
#define         TIOR2_IOB1 0x20
#define         TIOR2_IOB2 0x40
#define     TSTR (*((volatile unsigned  char *)(0xFFFF60)))  // 16rbg^C} 
#define     TSNC (*((volatile unsigned  char *)(0xFFFF61)))  // 16rbg^C} 
#define     TMDR (*((volatile unsigned  char *)(0xFFFF62)))  // 16rbg^C} 
#define     TOLR (*((volatile unsigned  char *)(0xFFFF63)))  // 16rbg^C} 
#define    TISRA (*((volatile unsigned  char *)(0xFFFF64)))  // 16rbg^C} 
#define    TISRB (*((volatile unsigned  char *)(0xFFFF65)))  // 16rbg^C} 
#define    TISRC (*((volatile unsigned  char *)(0xFFFF66)))  // 16rbg^C} 
#define   T16CR0 (*((volatile unsigned  char *)(0xFFFF68)))  // 16rbg^C} `l0
#define    TIOR0 (*((volatile unsigned  char *)(0xFFFF69)))  // 16rbg^C} `l0
#define T16CNT0H (*((volatile unsigned short *)(0xFFFF6A)))  // 16rbg^C} `l0
#define    GRA0H (*((volatile unsigned short *)(0xFFFF6C)))  // 16rbg^C} `l0
#define    GRB0H (*((volatile unsigned short *)(0xFFFF6E)))  // 16rbg^C} `l0
#define   T16CR1 (*((volatile unsigned  char *)(0xFFFF70)))  // 16rbg^C} `l1
#define    TIOR1 (*((volatile unsigned  char *)(0xFFFF71)))  // 16rbg^C} `l1
#define T16CNT1H (*((volatile unsigned short *)(0xFFFF72)))  // 16rbg^C} `l1
#define    GRA1H (*((volatile unsigned short *)(0xFFFF74)))  // 16rbg^C} `l1
#define    GRB1H (*((volatile unsigned short *)(0xFFFF76)))  // 16rbg^C} `l1
#define   T16CR2 (*((volatile unsigned  char *)(0xFFFF78)))  // 16rbg^C} `l2
#define    TIOR2 (*((volatile unsigned  char *)(0xFFFF79)))  // 16rbg^C} `l2
#define T16CNT2H (*((volatile unsigned short *)(0xFFFF7A)))  // 16rbg^C} `l2
#define    GRA2H (*((volatile unsigned short *)(0xFFFF7C)))  // 16rbg^C} `l2
#define    GRB2H (*((volatile unsigned short *)(0xFFFF7E)))  // 16rbg^C} `l2

// 8rbg^C}
#define         T8CR_CKS0 0x01
#define         T8CR_CKS1 0x02
#define         T8CR_CKS2 0x04
#define        T8CR_CCLR0 0x08
#define        T8CR_CCLR1 0x10
#define         T8CR_OVIE 0x20
#define        T8CR_CMIEA 0x40
#define        T8CR_CMIEB 0x80
#define         T8CSR_OS0 0x01
#define         T8CSR_OS1 0x02
#define        T8CSR_OIS2 0x04
#define        T8CSR_OIS3 0x08
#define        T8CSR_ADTE 0x10
#define         T8CSR_ICE 0x10
#define         T8CSR_OVF 0x20
#define        T8CSR_CMFA 0x40
#define        T8CSR_CMFB 0x80

#define T80_BASE (0xFFFF80)
#define T81_BASE (0xFFFF81)
#define T82_BASE (0xFFFF90)
#define T83_BASE (0xFFFF91)

#define    T8CR (0)
#define   T8CSR (2)
#define   TCORA (4)
#define   TCORB (6)
#define   T8CNT (8)

// WDT
#define          TCSR_CKS0 0x01
#define          TCSR_CKS1 0x02
#define          TCSR_CKS2 0x04
#define           TCSR_TME 0x20
#define         TCSR_WT_IT 0x40
#define           TCSR_OVF 0x80
#define        RSTCSR_WRST 0x80
#define     TCSR (*((volatile unsigned  char *)(0xFFFF8C)))  // WDT
#define     TCNT (*((volatile unsigned  char *)(0xFFFF8D)))  // WDT
#define   RSTCSR (*((volatile unsigned  char *)(0xFFFF8F)))  // WDT

// TPC
#define         TPMR_G0NOV 0x01
#define         TPMR_G1NOV 0x02
#define         TPMR_G2NOV 0x04
#define         TPMR_G3NOV 0x08
#define        TPCR_G0CMS0 0x01
#define        TPCR_G0CMS1 0x02
#define        TPCR_G1CMS0 0x04
#define        TPCR_G1CMS1 0x08
#define        TPCR_G2CMS0 0x10
#define        TPCR_G2CMS1 0x20
#define        TPCR_G3CMS0 0x40
#define        TPCR_G3CMS1 0x80
#define        NDERB_NDER8 0x01
#define        NDERB_NDER9 0x02
#define       NDERB_NDER10 0x04
#define       NDERB_NDER11 0x08
#define       NDERB_NDER12 0x10
#define       NDERB_NDER13 0x20
#define       NDERB_NDER14 0x40
#define       NDERB_NDER15 0x80
#define        NDERA_NDER0 0x01
#define        NDERA_NDER1 0x02
#define        NDERA_NDER2 0x04
#define        NDERA_NDER3 0x08
#define        NDERA_NDER4 0x10
#define        NDERA_NDER5 0x20
#define        NDERA_NDER6 0x40
#define        NDERA_NDER7 0x80
#define         NDRB0_NDR8 0x01
#define         NDRB0_NDR9 0x02
#define        NDRB0_NDR10 0x04
#define        NDRB0_NDR11 0x08
#define        NDRB0_NDR12 0x10
#define        NDRB0_NDR13 0x20
#define        NDRB0_NDR14 0x40
#define        NDRB0_NDR15 0x80
#define         NDRA0_NDR0 0x01
#define         NDRA0_NDR1 0x02
#define         NDRA0_NDR2 0x04
#define         NDRA0_NDR3 0x08
#define         NDRA0_NDR4 0x10
#define         NDRA0_NDR5 0x20
#define         NDRA0_NDR6 0x40
#define         NDRA0_NDR7 0x80
#define         NDRB1_NDR8 0x01
#define         NDRB1_NDR9 0x02
#define        NDRB1_NDR10 0x04
#define        NDRB1_NDR11 0x08
#define         NDRA1_NDR0 0x01
#define         NDRA1_NDR1 0x02
#define         NDRA1_NDR2 0x04
#define         NDRA1_NDR3 0x08
#define     TPMR (*((volatile unsigned  char *)(0xFFFFA0)))  // TPC
#define     TPCR (*((volatile unsigned  char *)(0xFFFFA1)))  // TPC
#define    NDERB (*((volatile unsigned  char *)(0xFFFFA2)))  // TPC
#define    NDERA (*((volatile unsigned  char *)(0xFFFFA3)))  // TPC
#define    NDRB0 (*((volatile unsigned  char *)(0xFFFFA4)))  // TPC
#define    NDRA0 (*((volatile unsigned  char *)(0xFFFFA5)))  // TPC
#define    NDRB1 (*((volatile unsigned  char *)(0xFFFFA6)))  // TPC
#define    NDRA1 (*((volatile unsigned  char *)(0xFFFFA7)))  // TPC

// SCI
#define   SCI0_BASE (0xFFFFB0)
#define   SCI1_BASE (0xFFFFB8)
#define   SCI2_BASE (0xFFFFC0)

#define          SMR_CKS0 0x01
#define          SMR_CKS1 0x02
#define            SMR_MP 0x04
#define          SMR_STOP 0x08
#define            SMR_OE 0x10
#define            SMR_PE 0x20
#define           SMR_CHR 0x40
#define           SMR_C_A 0x80
#define          SCR_CKE0 0x01
#define          SCR_CKE1 0x02
#define          SCR_TEIE 0x04
#define          SCR_MPIE 0x08
#define            SCR_RE 0x10
#define            SCR_TE 0x20
#define           SCR_RIE 0x40
#define           SCR_TIE 0x80
#define          SSR_MPBT 0x01
#define           SSR_MPB 0x02
#define          SSR_TEND 0x04
#define           SSR_PER 0x08
#define           SSR_FER 0x10
#define          SSR_ORER 0x20
#define          SSR_RDRF 0x40
#define          SSR_TDRE 0x80
#define         SCMR_SMIF 0x01
#define         SCMR_SINV 0x04
#define         SCMR_SDIR 0x08
#define     SMR (0)  // SCI `l0
#define     BRR (1)  // SCI `l0
#define     SCR (2)  // SCI `l0
#define     TDR (3)  // SCI `l0
#define     SSR (4)  // SCI `l0
#define     RDR (5)  // SCI `l0
#define    SCMR (6)  // SCI `l0

// ADϊ
#define         ADDRAH_AD2 0x01
#define         ADDRAH_AD3 0x02
#define         ADDRAH_AD4 0x04
#define         ADDRAH_AD5 0x08
#define         ADDRAH_AD6 0x10
#define         ADDRAH_AD7 0x20
#define         ADDRAH_AD8 0x40
#define         ADDRAH_AD9 0x80
#define         ADDRAL_AD0 0x40
#define         ADDRAL_AD1 0x80
#define         ADDRBH_AD2 0x01
#define         ADDRBH_AD3 0x02
#define         ADDRBH_AD4 0x04
#define         ADDRBH_AD5 0x08
#define         ADDRBH_AD6 0x10
#define         ADDRBH_AD7 0x20
#define         ADDRBH_AD8 0x40
#define         ADDRBH_AD9 0x80
#define         ADDRBL_AD0 0x40
#define         ADDRBL_AD1 0x80
#define         ADDRCH_AD2 0x01
#define         ADDRCH_AD3 0x02
#define         ADDRCH_AD4 0x04
#define         ADDRCH_AD5 0x08
#define         ADDRCH_AD6 0x10
#define         ADDRCH_AD7 0x20
#define         ADDRCH_AD8 0x40
#define         ADDRCH_AD9 0x80
#define         ADDRCL_AD0 0x40
#define         ADDRCL_AD1 0x80
#define         ADDRDH_AD2 0x01
#define         ADDRDH_AD3 0x02
#define         ADDRDH_AD4 0x04
#define         ADDRDH_AD5 0x08
#define         ADDRDH_AD6 0x10
#define         ADDRDH_AD7 0x20
#define         ADDRDH_AD8 0x40
#define         ADDRDH_AD9 0x80
#define         ADDRDL_AD0 0x40
#define         ADDRDL_AD1 0x80
#define          ADCSR_CH0 0x01
#define          ADCSR_CH1 0x02
#define          ADCSR_CH2 0x04
#define          ADCSR_CKS 0x08
#define         ADCSR_SCAN 0x10
#define         ADCSR_ADST 0x20
#define         ADCSR_ADIE 0x40
#define          ADCSR_ADF 0x80
#define          ADCR_TRGE 0x80
#define   ADDRAH (*((volatile unsigned  char *)(0xFFFFE0)))  // ADϊ
#define   ADDRAL (*((volatile unsigned  char *)(0xFFFFE1)))  // ADϊ
#define   ADDRBH (*((volatile unsigned  char *)(0xFFFFE2)))  // ADϊ
#define   ADDRBL (*((volatile unsigned  char *)(0xFFFFE3)))  // ADϊ
#define   ADDRCH (*((volatile unsigned  char *)(0xFFFFE4)))  // ADϊ
#define   ADDRCL (*((volatile unsigned  char *)(0xFFFFE5)))  // ADϊ
#define   ADDRDH (*((volatile unsigned  char *)(0xFFFFE6)))  // ADϊ
#define   ADDRDL (*((volatile unsigned  char *)(0xFFFFE7)))  // ADϊ
#define    ADCSR (*((volatile unsigned  char *)(0xFFFFE8)))  // ADϊ
#define     ADCR (*((volatile unsigned  char *)(0xFFFFE9)))  // ADϊ

#endif //__H8_3069F_H__
