#ifndef __DRIVERS_H__
#define __DRIVERS_H__

#include <bios_api.h>

#define _bios_call_api_swi _aki_h8_3069_bios_call_api_swi
#define _bios_boot_check _aki_h8_3069_bios_boot_check

#define _plathome_uart_init _aki_h8_3069_uart_init
#define _uart_rx_ready _aki_h8_3069_uart_rx_ready
#define _uart_tx_ready _aki_h8_3069_uart_tx_ready
#define _uart_getc _aki_h8_3069_uart_getc
#define _uart_putc _aki_h8_3069_uart_putc

#define _uart_interrupt_enable _aki_h8_3069_uart_interrupt_enable
#define _uart_interrupt_disable _aki_h8_3069_uart_interrupt_disable

#define _uart_send_interrupt_enabled _aki_h8_3069_uart_send_interrupt_enabled
#define _plathome_uart_send_interrupt_enable _aki_h8_3069_uart_send_interrupt_enable
#define _plathome_uart_send_interrupt_disable _aki_h8_3069_uart_send_interrupt_disable

#define _uart_recv_interrupt_enabled _aki_h8_3069_uart_recv_interrupt_enabled
#define _plathome_uart_recv_interrupt_enable _aki_h8_3069_uart_recv_interrupt_enable
#define _plathome_uart_recv_interrupt_disable _aki_h8_3069_uart_recv_interrupt_disable

#define _interrupt_status _aki_h8_3069_interrupt_status
#define _interrupt_enable _aki_h8_3069_interrupt_enable
#define _interrupt_disable _aki_h8_3069_interrupt_disable
#define _interrupt_restore _aki_h8_3069_interrupt_restore
#define _interrupt_enable_num _aki_h8_3069_interrupt_enable_num
#define _interrupt_disable_num _aki_h8_3069_interrupt_disable_num
#define _interrupt_set_handler _aki_h8_3069_interrupt_set_handler
#define _interrupt_set_timer_handler _aki_h8_3069_interrupt_set_timer_handler

#define _timer_init _aki_h8_3069_timer_init
#define _timer_set_callback _aki_h8_3069_timer_set_callback

#define _flash_write _aki_h8_3069_flash_write
#define _flash_write_bios _aki_h8_3069_flash_write_bios


/// \defgroup INTERNAL_API_AKI_H8_3069 AKI_H8-3069pAPI
/// \ingroup AKI_H8_3069
/// AKI-H8-3069 BIOSŗpAPIZbgłB
//@{
int _aki_h8_3069_bios_call_api_swi(  volatile int API_NUM, volatile int LPARAM, volatile void *RPARAM );

int _aki_h8_3069_bios_boot_check( void );

int _aki_h8_3069_interrupt_status( void );          
int _aki_h8_3069_interrupt_enable( void );          
int _aki_h8_3069_interrupt_disable( void );
void _aki_h8_3069_interrupt_restore( int status );
int _aki_h8_3069_interrupt_enable_num( int number );
int _aki_h8_3069_interrupt_disable_num( int number );
int _aki_h8_3069_interrupt_set_handler( int number, bios_interrupt_handler_t handler );

int _aki_h8_3069_uart_init( int port, bios_uart_param_t *params );
int _aki_h8_3069_uart_rx_ready( int port );
int _aki_h8_3069_uart_tx_ready( int port );
int _aki_h8_3069_uart_getc( int port );
int _aki_h8_3069_uart_putc( int port, unsigned char c );

int _aki_h8_3069_uart_interrupt_enable( int port );
int _aki_h8_3069_uart_interrupt_disable( int port );
int _aki_h8_3069_uart_send_interrupt_enabled( int port );
int _aki_h8_3069_uart_send_interrupt_enable( int port );
int _aki_h8_3069_uart_send_interrupt_disable( int port );
int _aki_h8_3069_uart_recv_interrupt_enabled( int port );
int _aki_h8_3069_uart_recv_interrupt_enable( int port );
int _aki_h8_3069_uart_recv_interrupt_disable( int port );

int _aki_h8_3069_timer_init( void );
int _aki_h8_3069_timer_set_callback( bios_timer_callback_t callback );

void  _aki_h8_3069_flash_write( void *address, void *data, int length, int verbose );
void  _aki_h8_3069_flash_write_bios( void *address, void *data, int length );
//@}

#endif //__DRIVERS_H__
