#include <internal_api.h>
#include <plathome.h>
#include <drivers.h>
typedef struct
{
    int enable:1;
    unsigned int handler:24;
} interrupt_table_t;
interrupt_table_t vectors[64];

static int trap0_rval;
static void trap0_handler( int api_num, int lparam, void *rparam )
{
    trap0_rval = _bios_call_api_direct( api_num, lparam, rparam );
}

void enable_swi( void )
{
    _aki_h8_3069_interrupt_enable_num( INTERRUPT_AKI_H8_3069_TRAP0 );
    _aki_h8_3069_interrupt_set_handler( INTERRUPT_AKI_H8_3069_TRAP0, (bios_interrupt_handler_t)trap0_handler );
}

int _aki_h8_3069_bios_call_api_swi(  volatile int API_NUM, volatile int LPARAM, volatile void *RPARAM )
{
	asm volatile ("trapa	#0");
    return trap0_rval;
}

void interrupt_handler( int id )
{
    if ( vectors[id].enable )
    {
        ((bios_interrupt_handler_t)vectors[id].handler)();
    }
}

int _aki_h8_3069_interrupt_status( void )
{
    int status = 0;
    asm volatile ("stc.w ccr, %0" : "+m"(status) );
    return status & 0x80;
}

int _aki_h8_3069_interrupt_enable( void )
{
    int status = 0;
    asm volatile ("stc.w ccr, %0" : "+m"(status) );
    asm volatile ("andc #0x7f,ccr");
    return status & 0x80;
}

int _aki_h8_3069_interrupt_disable( void )
{
    int status = 0;
    asm volatile ("stc.w ccr, %0" : "+m"(status) );
    asm volatile("orc #0x80,ccr");
    return status & 0x80;
}

void _aki_h8_3069_interrupt_restore( int status )
{
    if ( status )
    {
        asm volatile("orc #0x80,ccr");
    }
    else
    {
        asm volatile ("andc #0x7f,ccr");
    }
}

int _aki_h8_3069_interrupt_enable_num( int number )
{
    vectors[number].enable = 1;
    return BIOS_NOERR;
}

int _aki_h8_3069_interrupt_disable_num( int number )
{
    vectors[number].enable = 0;
    return BIOS_NOERR;
}

int _aki_h8_3069_interrupt_set_handler( int number, bios_interrupt_handler_t handler )
{
    int status;
    status = _aki_h8_3069_interrupt_disable();
    vectors[number].handler = (unsigned int)handler;
    _aki_h8_3069_interrupt_restore(status);
    return BIOS_NOERR;
}

