#include <h8_3069f/h8_3069f.h>

#define FP_BASE (0xffbf20)

typedef int (*init_program_t)( unsigned long param1, unsigned long param2 );
typedef int (*erase_program_t)( unsigned long param1 );
typedef int (*write_program_t)( unsigned long param1, unsigned long param2 );
#define DPFR            (*(volatile unsigned char *)FP_BASE)

inline int download_program( int erase_or_write )
{
    DPFR = 0xff;
    if ( erase_or_write ) // erase
    {
        FPCS = 0;
        FECS = 1;
    }
    else
    {
        FPCS = 1;
        FECS = 0;
    }
    FTDAR = 3;
    FKEY  = 0xa5;
    FCCS  |= FCCS_SCO;
    asm volatile ( "NOP\n\tNOP\n\tNOP\n\tNOP\n\t" );
    FKEY  = 0;
    return DPFR;
}

int flash_copy( unsigned long source,  unsigned long destination, int length, int verbose, int reboot )
{
    volatile unsigned int *log_addr = (volatile unsigned int *)0x00480000;
    {
        int i;
        for ( i = 0; i < 1024; i++ )
            *(log_addr + i ) = 0;
    }

    int status;
    unsigned long block_no = 16;
    *log_addr ++ = 1;
    switch ( destination )
    {
        case 0x00000: block_no = 0;  break; // EB0
        case 0x01000: block_no = 1;  break; // EB1
        case 0x02000: block_no = 2;  break; // EB2
        case 0x03000: block_no = 3;  break; // EB3
        case 0x04000: block_no = 4;  break; // EB4
        case 0x05000: block_no = 5;  break; // EB5
        case 0x06000: block_no = 6;  break; // EB6
        case 0x07000: block_no = 7;  break; // EB7
        case 0x08000: block_no = 8;  break; // EB8
        case 0x10000: block_no = 9;  break; // EB9
        case 0x20000: block_no = 10; break; // EB10
        case 0x30000: block_no = 11; break; // EB11
        case 0x40000: block_no = 12; break; // EB12
        case 0x50000: block_no = 13; break; // EB13
        case 0x60000: block_no = 14; break; // EB14
        case 0x70000: block_no = 15; break; // EB15
    }
//    if ( 0 )
    if ( block_no < 16 )
    {
        status = download_program( 1 );
        if ( status != 0 )
        {
            *log_addr ++ = 2;
            return 0x010000 | status;
            *log_addr ++ = 3;
        }
        status = (((init_program_t)(FP_BASE + 32))(2500, 0 ) & 0xff);
        if ( status != 0 )
        {
            *log_addr ++ = 4;
            return 0x020000 | status;
            *log_addr ++ = 5;
        }
        FKEY  = 0x5a;
        *log_addr ++ = 6;
        status = ((erase_program_t)(FP_BASE + 16))(block_no) & 0xff;
        *log_addr ++ = 7;
        FKEY  = 0;
        *log_addr ++ = 8;
        if ( status != 0 )
        {
            *log_addr ++ = 9;
            return 0x030000 | status;
            *log_addr ++ = 10;
        }
    }
    status = download_program( 0 );
    *log_addr ++ = 11;
    if ( status != 0 )
    {
        return 0x040000 | status;
    }
    status = (((init_program_t)(FP_BASE + 32))( 2500, 0 ) & 0xff);
    *log_addr ++ = 12;
    if ( status != 0 )
    {
        return 0x050000 | status;
    }

    while ( length >= 0 )
    {
        FKEY  = 0x5a;
        *log_addr ++ = 13;
        status = (((write_program_t)(FP_BASE + 16))( source, destination ) & 0xff);
        *log_addr ++ = destination;
        FKEY  = 0;
        if ( status != 0 )
        {
            return 0x060000 | status;
        }
        length    -= 128;
        source  += 128;
        destination += 128;
    }
    
    return 0;
}
