
#include <string.h>
#include <internal_api.h>
#include <plathome.h>
#include <at91/reg_r40807.h>

#include <shell/shell_uart.h>
#include <shell/shell_string.h>
#include <shell/shell_printf.h>

#include <shell/command.h>

static int timer( int argc, char **argv );
static int uart( int argc, char **argv );
static int uartsend( int argc, char **argv );
static int test( int argc, char **argv );

static shell_command_list_t const internal_command_table[] =
{
    { "timer",     timer,     "TimereXg" },
    { "uart",      uart,      "UarteXg" },
    { "uartsend",  uartsend,  "UartSendeXg" },
    { "test",      test,      "eXgR}h" },
    { "EXTR}h",0,0 }
};

void timer_handler( void )
{
    static int seccounter = 0;
    static int counter = 0;
	TCB0_BASE->TC[ 0 ].TC_CV -= TCB0_BASE->TC[ 0 ].TC_RC;
    TCB0_BASE->TC[ 0 ].TC_SR;
    if ( ++counter >= 1000 )
    {
        shell_printf( " %x\n", seccounter );
        seccounter ++;
        counter = 0;
    }
}

static int timer( int argc, char **argv )
{
    _aki_arm7_interrupt_set_handler( 4, (bios_interrupt_handler_t)timer_handler );
    _aki_arm7_interrupt_enable_num( 4 );
    
	TCB0_BASE->TC[ 0 ].TC_CCR = TC_CLKDIS;
	TCB0_BASE->TC_BMR = TC_NONEXC2 | TC_NONEXC1 | TC_NONEXC0;
	TCB0_BASE->TC[ 0 ].TC_RC = 16667;
	TCB0_BASE->TC[ 0 ].TC_CMR = 0 | TC_CPCTRG; // MCLK/2
	TCB0_BASE->TC[ 0 ].TC_CV = 0;
	TCB0_BASE->TC[ 0 ].TC_IER = TC_CPCS;
	TCB0_BASE->TC[ 0 ].TC_SR;
	TCB0_BASE->TC[ 0 ].TC_CCR = TC_CLKEN | TC_SWTRG;
    
    _aki_arm7_interrupt_enable();
    return BIOS_NOERR;
}

#include <queue.h>
QUEUE_INIT(UART_TX_TEST, 4, 2);

void uart1_recv_callback( void )
{
    int c;
    c = _aki_arm7_uart_getc(1);
    shell_printf( "  2.2X[]\n", c );
}

void uart1_send_callback( void )
{
    if( !QUEUE_ISEMPTY(UART_TX_TEST, 1) )
    {
        unsigned char data;
        QUEUE_OUT(UART_TX_TEST, 1, data);
        _aki_arm7_uart_putc(1, data);
        
    }
    if( QUEUE_ISEMPTY(UART_TX_TEST, 1) )
    {
        USART1_BASE->US_IDR = US_TXRDY;
    }
}

void uart1_handler( void )
{
    if ( (USART1_BASE->US_CSR & USART1_BASE->US_IMR) & US_RXRDY )
    {
        uart1_recv_callback();
    }

    if ( (USART1_BASE->US_CSR & USART1_BASE->US_IMR) & US_TXRDY )
    {
        uart1_send_callback();
    }
}


static int uart( int argc, char **argv )
{
    _uart_init( 1, 0 );

    _aki_arm7_interrupt_set_handler( 3, (bios_interrupt_handler_t)uart1_handler );
    _aki_arm7_interrupt_enable_num( 3 );

    USART1_BASE->US_IER = US_RXRDY;    
    _aki_arm7_interrupt_enable();
    
    return BIOS_NOERR;
}

static int uartsend( int argc, char **argv )
{
    unsigned char data;
    char *str;
    if ( argc <= 1 )
    {
        return BIOS_SHELL_INVALID_ARGS;
    }
    str = *++argv;
    
    while( *str )
    {
        if ( QUEUE_ISFULL(UART_TX_TEST, 1) )
        {
            if ( ( USART1_BASE->US_IMR & US_TXRDY ) )
            {
                return BIOS_ERR;
            }
            else
            {
                QUEUE_OUT( UART_TX_TEST, 1, data );
                _aki_arm7_uart_putc(1, data);
                USART1_BASE->US_IER = US_TXRDY;
            }
        }
        QUEUE_IN(UART_TX_TEST, 1, *str++);
    }
    if ( !QUEUE_ISEMPTY(UART_TX_TEST, 1) &
         (!( USART1_BASE->US_IMR & US_TXRDY )) )
    {
        QUEUE_OUT( UART_TX_TEST, 1, data );
        _aki_arm7_uart_putc(1, data);
        USART1_BASE->US_IER = US_TXRDY;
    }
    
    return BIOS_NOERR;
}


static int test( int argc, char **argv )
{
// ĂƂ
    shell_printf( "test command \n" );
    shell_printf( "(10i) %d\n", 10 );
    shell_printf( "(16i) %x\n", 10 );

    PIO_PER = PIOTXD1 | PIORXD1;
    PIO_PDR = P19 | P20;
    return BIOS_NOERR;
}

int exec_extra_command( int argc, char **argv )
{
    return exec_command( (shell_command_list_t *)internal_command_table, argc, argv );
}
