#include    "r40807.h"

/*----------------------------*/
/* Special Function Registers */
/*----------------------------*/

#define SF_CIDR     (SF_BASE->SF_CIDR)
#define SF_EXID     (SF_BASE->SF_EXID)
#define SF_RSF      (SF_BASE->SF_RSF)
#define SF_MMR      (SF_BASE->SF_MMR)
#define SF_PMR      (SF_BASE->SF_PMR)

/*----------------------------------*/
/* External Bus Interface Registers */
/*----------------------------------*/

#define EBI_CSR0        (EBI_BASE->EBI_CSR[0])
#define EBI_CSR1        (EBI_BASE->EBI_CSR[1])
#define EBI_CSR2        (EBI_BASE->EBI_CSR[2])
#define EBI_CSR3        (EBI_BASE->EBI_CSR[3])
#define EBI_CSR4        (EBI_BASE->EBI_CSR[4])
#define EBI_CSR5        (EBI_BASE->EBI_CSR[5])
#define EBI_CSR6        (EBI_BASE->EBI_CSR[6])
#define EBI_CSR7        (EBI_BASE->EBI_CSR[7])
#define EBI_RCR         (EBI_BASE->EBI_RCR)
#define EBI_MCR         (EBI_BASE->EBI_MCR)

/*---------------------------------------*/
/* Power Saving Controller Registers */
/*---------------------------------------*/

#define PS_CR          (PS_BASE->PS_CR)
#define PS_PCER        (PS_BASE->PS_PCER)
#define PS_PDCR        (PS_BASE->PS_PDCR)
#define PS_PCSR        (PS_BASE->PS_PCSR)

/*-----------------------------------------*/
/* Advanced Interrupt Controller Registers */
/*-----------------------------------------*/

#define AIC_SMR0    (AIC_BASE->AIC_SMR[0])
#define AIC_SMR1    (AIC_BASE->AIC_SMR[1])
#define AIC_SMR2    (AIC_BASE->AIC_SMR[2])
#define AIC_SMR3    (AIC_BASE->AIC_SMR[3])
#define AIC_SMR4    (AIC_BASE->AIC_SMR[4])
#define AIC_SMR5    (AIC_BASE->AIC_SMR[5])
#define AIC_SMR6    (AIC_BASE->AIC_SMR[6])
#define AIC_SMR7    (AIC_BASE->AIC_SMR[7])
#define AIC_SMR8    (AIC_BASE->AIC_SMR[8])
#define AIC_SMR9    (AIC_BASE->AIC_SMR[9])
#define AIC_SMR10   (AIC_BASE->AIC_SMR[10])
#define AIC_SMR11   (AIC_BASE->AIC_SMR[11])
#define AIC_SMR12   (AIC_BASE->AIC_SMR[12])
#define AIC_SMR13   (AIC_BASE->AIC_SMR[13])
#define AIC_SMR14   (AIC_BASE->AIC_SMR[14])
#define AIC_SMR15   (AIC_BASE->AIC_SMR[15])
#define AIC_SMR16   (AIC_BASE->AIC_SMR[16])
#define AIC_SMR17   (AIC_BASE->AIC_SMR[17])
#define AIC_SMR18   (AIC_BASE->AIC_SMR[18])
#define AIC_SMR19   (AIC_BASE->AIC_SMR[19])
#define AIC_SMR20   (AIC_BASE->AIC_SMR[20])
#define AIC_SMR21   (AIC_BASE->AIC_SMR[21])
#define AIC_SMR22   (AIC_BASE->AIC_SMR[22])
#define AIC_SMR23   (AIC_BASE->AIC_SMR[23])
#define AIC_SMR24   (AIC_BASE->AIC_SMR[24])
#define AIC_SMR25   (AIC_BASE->AIC_SMR[25])
#define AIC_SMR26   (AIC_BASE->AIC_SMR[26])
#define AIC_SMR27   (AIC_BASE->AIC_SMR[27])
#define AIC_SMR28   (AIC_BASE->AIC_SMR[28])
#define AIC_SMR29   (AIC_BASE->AIC_SMR[29])
#define AIC_SMR30   (AIC_BASE->AIC_SMR[30])
#define AIC_SMR31   (AIC_BASE->AIC_SMR[31])

#define AIC_SVR0    (AIC_BASE->AIC_SVR[0])
#define AIC_SVR1    (AIC_BASE->AIC_SVR[1])
#define AIC_SVR2    (AIC_BASE->AIC_SVR[2])
#define AIC_SVR3    (AIC_BASE->AIC_SVR[3])
#define AIC_SVR4    (AIC_BASE->AIC_SVR[4])
#define AIC_SVR5    (AIC_BASE->AIC_SVR[5])
#define AIC_SVR6    (AIC_BASE->AIC_SVR[6])
#define AIC_SVR7    (AIC_BASE->AIC_SVR[7])
#define AIC_SVR8    (AIC_BASE->AIC_SVR[8])
#define AIC_SVR9    (AIC_BASE->AIC_SVR[9])
#define AIC_SVR10   (AIC_BASE->AIC_SVR[10])
#define AIC_SVR11   (AIC_BASE->AIC_SVR[11])
#define AIC_SVR12   (AIC_BASE->AIC_SVR[12])
#define AIC_SVR13   (AIC_BASE->AIC_SVR[13])
#define AIC_SVR14   (AIC_BASE->AIC_SVR[14])
#define AIC_SVR15   (AIC_BASE->AIC_SVR[15])
#define AIC_SVR16   (AIC_BASE->AIC_SVR[16])
#define AIC_SVR17   (AIC_BASE->AIC_SVR[17])
#define AIC_SVR18   (AIC_BASE->AIC_SVR[18])
#define AIC_SVR19   (AIC_BASE->AIC_SVR[19])
#define AIC_SVR20   (AIC_BASE->AIC_SVR[20])
#define AIC_SVR21   (AIC_BASE->AIC_SVR[21])
#define AIC_SVR22   (AIC_BASE->AIC_SVR[22])
#define AIC_SVR23   (AIC_BASE->AIC_SVR[23])
#define AIC_SVR24   (AIC_BASE->AIC_SVR[24])
#define AIC_SVR25   (AIC_BASE->AIC_SVR[25])
#define AIC_SVR26   (AIC_BASE->AIC_SVR[26])
#define AIC_SVR27   (AIC_BASE->AIC_SVR[27])
#define AIC_SVR28   (AIC_BASE->AIC_SVR[28])
#define AIC_SVR29   (AIC_BASE->AIC_SVR[29])
#define AIC_SVR30   (AIC_BASE->AIC_SVR[30])
#define AIC_SVR31   (AIC_BASE->AIC_SVR[31])


#define AIC_IVR     (AIC_BASE->AIC_IVR)
#define AIC_FVR     (AIC_BASE->AIC_FVR)
#define AIC_ISR     (AIC_BASE->AIC_ISR)
#define AIC_IPR     (AIC_BASE->AIC_IPR)
#define AIC_IMR     (AIC_BASE->AIC_IMR)
#define AIC_CISR    (AIC_BASE->AIC_CISR)
#define AIC_IECR    (AIC_BASE->AIC_IECR)
#define AIC_IDCR    (AIC_BASE->AIC_IDCR)
#define AIC_ICCR    (AIC_BASE->AIC_ICCR)
#define AIC_ISCR    (AIC_BASE->AIC_ISCR)
#define AIC_EOICR   (AIC_BASE->AIC_EOICR)
#define AIC_SPU     (AIC_BASE->AIC_SPU)


/*------------------------*/
/* System Timer Registers */
/*------------------------*/

#define ST_CR       (ST_BASE->ST_CR)
#define ST_PIMR     (ST_BASE->ST_PIMR)
#define ST_WDMR     (ST_BASE->ST_WDMR)
#define ST_RTMR     (ST_BASE->ST_RTMR)
#define ST_SR       (ST_BASE->ST_SR)
#define ST_IER      (ST_BASE->ST_IER)
#define ST_IDR      (ST_BASE->ST_IDR)
#define ST_IMR      (ST_BASE->ST_IMR)
#define ST_RTAR     (ST_BASE->ST_RTAR)
#define ST_CRTR     (ST_BASE->ST_CRTR)

/*----------------------------------*/
/* Parallel IO Controller Registers */
/*----------------------------------*/

#define PIO_PER     (PIO_BASE->PIO_PER)
#define PIO_PDR     (PIO_BASE->PIO_PDR)
#define PIO_PSR     (PIO_BASE->PIO_PSR)

#define PIO_OER     (PIO_BASE->PIO_OER)
#define PIO_ODR     (PIO_BASE->PIO_ODR)
#define PIO_OSR     (PIO_BASE->PIO_OSR)

#define PIO_IFER    (PIO_BASE->PIO_IFER)
#define PIO_IFDR    (PIO_BASE->PIO_IFDR)
#define PIO_IFSR    (PIO_BASE->PIO_IFSR)

#define PIO_SODR    (PIO_BASE->PIO_SODR)
#define PIO_CODR    (PIO_BASE->PIO_CODR)
#define PIO_ODSR    (PIO_BASE->PIO_ODSR)
#define PIO_PDSR    (PIO_BASE->PIO_PDSR)

#define PIO_IER     (PIO_BASE->PIO_IER)
#define PIO_IDR     (PIO_BASE->PIO_IDR)
#define PIO_IMR     (PIO_BASE->PIO_IMR)
#define PIO_ISR     (PIO_BASE->PIO_ISR)

/*----------------------------*/
/* USART 0, 1 and 2 Registers */
/*----------------------------*/

#define US0_CR      (USART0_BASE->US_CR)
#define US1_CR      (USART1_BASE->US_CR)

#define US0_MR      (USART0_BASE->US_MR)
#define US1_MR      (USART1_BASE->US_MR)

#define US0_IER     (USART0_BASE->US_IER)
#define US1_IER     (USART1_BASE->US_IER)

#define US0_IDR     (USART0_BASE->US_IDR)
#define US1_IDR     (USART1_BASE->US_IDR)

#define US0_IMR     (USART0_BASE->US_IMR)
#define US1_IMR     (USART1_BASE->US_IMR)

#define US0_CSR     (USART0_BASE->US_CSR)
#define US1_CSR     (USART1_BASE->US_CSR)

#define US0_RHR     (USART0_BASE->US_RHR)
#define US1_RHR     (USART1_BASE->US_RHR)

#define US0_THR     (USART0_BASE->US_THR)
#define US1_THR     (USART1_BASE->US_THR)

#define US0_BRGR    (USART0_BASE->US_BRGR)
#define US1_BRGR    (USART1_BASE->US_BRGR)

#define US0_RTOR    (USART0_BASE->US_RTOR)
#define US1_RTOR    (USART1_BASE->US_RTOR)

#define US0_TTGR    (USART0_BASE->US_TTGR)
#define US1_TTGR    (USART1_BASE->US_TTGR)

#define US0_RPR     (USART0_BASE->US_RPR)
#define US1_RPR     (USART1_BASE->US_RPR)

#define US0_RCR     (USART0_BASE->US_RCR)
#define US1_RCR     (USART1_BASE->US_RCR)

#define US0_TPR     (USART0_BASE->US_TPR)
#define US1_TPR     (USART1_BASE->US_TPR)

#define US0_TCR     (USART0_BASE->US_TCR)
#define US1_TCR     (USART1_BASE->US_TCR)

/*-------------------------*/
/* Timer Counter Registers */
/*-------------------------*/


#define TCB0_BCR    (TCB0_BASE->TC_BCR)
#define TCB0_BMR    (TCB0_BASE->TC_BMR)

#define TC0_CCR     (TC0_BASE->TC_CCR)
#define TC0_CMR     (TC0_BASE->TC_CMR)
#define TC0_CV      (TC0_BASE->TC_CV)
#define TC0_RA      (TC0_BASE->TC_RA)
#define TC0_RB      (TC0_BASE->TC_RB)
#define TC0_RC      (TC0_BASE->TC_RC)
#define TC0_SR      (TC0_BASE->TC_SR)
#define TC0_IER     (TC0_BASE->TC_IER)
#define TC0_IDR     (TC0_BASE->TC_IDR)
#define TC0_IMR     (TC0_BASE->TC_IMR)

#define TC1_CCR     (TC1_BASE->TC_CCR)
#define TC1_CMR     (TC1_BASE->TC_CMR)
#define TC1_CV      (TC1_BASE->TC_CV)
#define TC1_RA      (TC1_BASE->TC_RA)
#define TC1_RB      (TC1_BASE->TC_RB)
#define TC1_RC      (TC1_BASE->TC_RC)
#define TC1_SR      (TC1_BASE->TC_SR)
#define TC1_IER     (TC1_BASE->TC_IER)
#define TC1_IDR     (TC1_BASE->TC_IDR)
#define TC1_IMR     (TC1_BASE->TC_IMR)

#define TC2_CCR     (TC2_BASE->TC_CCR)
#define TC2_CMR     (TC2_BASE->TC_CMR)
#define TC2_CV      (TC2_BASE->TC_CV)
#define TC2_RA      (TC2_BASE->TC_RA)
#define TC2_RB      (TC2_BASE->TC_RB)
#define TC2_RC      (TC2_BASE->TC_RC)
#define TC2_SR      (TC2_BASE->TC_SR)
#define TC2_IER     (TC2_BASE->TC_IER)
#define TC2_IDR     (TC2_BASE->TC_IDR)
#define TC2_IMR     (TC2_BASE->TC_IMR)


#define WD_OMR      (WD_BASE->WD_OMR)
#define WD_CMR      (WD_BASE->WD_CMR)
#define WD_CR       (WD_BASE->WD_CR)
