#include <drivers/flash.h>

#include <at91/reg_r40807.h>

static inline void ram_putc( char c )
{
    while (!(USART0_BASE->US_CSR & (US_TXRDY | US_TXEMPTY))) {}
    USART0_BASE->US_THR = c;
}

typedef void (*func_reboot_t)(void);
void _aki_arm7_flash_write_ram_bios( unsigned long addr, unsigned short *pData, int length )
{
    _aki_arm7_flash_write_ram( addr, pData, length, 1 );
    ram_putc( 'R' );
    ram_putc( 'e' );
    ram_putc( 'b' );
    ram_putc( 'o' );
    ram_putc( 'o' );
    ram_putc( 't' );
    ram_putc( 'i' );
    ram_putc( 'n' );
    ram_putc( 'g' );
    ram_putc( '\r' );
    ram_putc( '\n' );
    ((func_reboot_t)0)();
    while( 1 );
}

void _aki_arm7_flash_write_ram( unsigned long addr, unsigned short *pData, int length, int verbose )
{
    volatile int i, j;
    int err, retry = 10;
    ram_putc( 'W' );
    ram_putc( 'r' );
    ram_putc( 'i' );
    ram_putc( 't' );
    ram_putc( 'i' );
    ram_putc( 'n' );
    ram_putc( 'g' );
    ram_putc( '\r' );
    ram_putc( '\n' );
    do
    {
        do
        {
            *((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0xAAAA;
            *((volatile unsigned short *)( FLASH_TOP + (0x2AAA << 1))) = 0x5555;
            *((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0xA0A0;
            for( i = 0; i < 128; i++ )
            {
                
                *(volatile unsigned short *)(addr + (i<<1)) = *(pData + i);
            }
            for( j = 0; j < 33*2000; j++ );
            while (!(USART0_BASE->US_CSR & (US_TXRDY | US_TXEMPTY))) {}
            USART0_BASE->US_THR = '.';

            err = 0;
            for( i = 0; i < 128; i++ )
            {
                if ( *(volatile unsigned short *)(addr + (i<<1)) != *(pData + i) )
                {
                    err = 1;
                }
            }
        }
        while( (retry --) && err );

        if ( (retry == 0) && err ) return;
        
        USART0_BASE->US_THR = '*';

        retry = 10;
        err = 0;

        pData += 128;
        addr += 256;
        length -= 256;
    } while( length > 0 );
    ram_putc( '\r' );
    ram_putc( '\n' );
    ram_putc( 'D' );
    ram_putc( 'o' );
    ram_putc( 'n' );
    ram_putc( 'e' );
    ram_putc( '\r' );
    ram_putc( '\n' );
}
