#include <drivers.h>
#include <drivers/flash.h>
#include <drivers/interrupt.h>

void _aki_arm7_flash_initialize( void )
{
}

void* _aki_arm7_flash_sector_top( void *address )
{
	unsigned long addr;

	addr = ((unsigned long) address ) & 0xFFFFFF00;
	if( (addr & 0xFFFE0000) != FLASH_TOP ) return 0;
	return (void*) addr;
}

int _aki_arm7_flash_sector_size( void *address )
{
	unsigned long addr;

	addr = ((unsigned long) address ) & 0xFFFFFF00;
	if( (addr & 0xFFFE0000) != FLASH_TOP ) return 0;

	return 256;	/* 128word * 2byte */
}

void _aki_arm7_flash_erase_all( void *address )
{
	unsigned long addr;
	volatile int j;
	int State;

	addr = ((unsigned long) address ) & 0xFFFFFF00;
	if( (addr & 0xFFFE0000) != FLASH_TOP ) return;

	State = _interrupt_disable();
	*((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0xAAAA;
	*((volatile unsigned short *)( FLASH_TOP + (0x2AAA << 1))) = 0x5555;
	*((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0x8080;
	*((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0xAAAA;
	*((volatile unsigned short *)( FLASH_TOP + (0x2AAA << 1))) = 0x5555;
	*((volatile unsigned short *)( FLASH_TOP + (0x5555 << 1))) = 0x1010;
	for( j = 0; j < 33*20000; j++ );
	_interrupt_restore( State );
}

void _aki_arm7_flash_write( void *address, void *pWriteData, int length, int verbose )
{
	int State;
	unsigned long addr;
	unsigned short *pData;

    _aki_arm7_flash_initialize();

    addr = ((unsigned long) address ) & 0xFFFFFF00;
    if ( (addr != (unsigned long)address) ||( (addr & 0xFFFE0000) != FLASH_TOP ) ) return;
	pData = (unsigned short*) pWriteData;
	State = _aki_arm7_interrupt_disable();
    _aki_arm7_flash_write_ram( addr, pData, length, verbose );
	_aki_arm7_interrupt_restore( State );
}

void _aki_arm7_flash_write_bios( void *address, void *pWriteData, int length )
{
	int State;
	unsigned long addr;
	unsigned short *pData;

    _aki_arm7_flash_initialize();

    addr = ((unsigned long) address ) & 0xFFFFFF00;
    if ( (addr != (unsigned long)address) ||( (addr & 0xFFFE0000) != FLASH_TOP ) ) return;
	pData = (unsigned short*) pWriteData;
	State = _aki_arm7_interrupt_disable();
    _aki_arm7_flash_write_ram_bios( addr, pData, length );
	_aki_arm7_interrupt_restore( State );
}
