@ ---------------------------------------------------------
@	AT91R40807 Startup code for Secondary RAM boot
@ =========================================================
@	(C)2004 t.hara
@ ---------------------------------------------------------

	.section	.text
	.global		_start

@ ---------------------------------------------------------
@	interrupt vector
@ ---------------------------------------------------------
InterruptVector:
	ldr			pc, =_start
        b                       undefined_handler
        b                       swi_handler
        b                       prefetch_abort_handler
        b                       data_abort_handler
	nop
        b                       default_irq_handler

fiq_int:
	ldr			r8, =0xfffff000
	ldr			pc, [r8, #0x104]	@ jump to (AIC_FVR register)

_start:
	@ -- initialize stack pointer -------------------------
	mov			r0, #0xD1			@ set FIQ mode and disable interrupt
	msr			cpsr_c, r0
	ldr			sp, =_fiq_stack

	mov			r0, #0xD2			@ set IRQ mode and disable interrupt
	msr			cpsr_c, r0
	ldr			sp, =_irq_stack

	mov			r0, #0xDF			@ set System mode and disable interrupt
	msr			cpsr_c, r0

	ldr			sp, =_stack

	@ -- initialize interrupt setting ---------------------
	mov			r1, #0xFFFFFFFF
	ldr			r0, =0xFFFF0000			@ PIO
	str			r1, [r0, #0x44]			@ PIO_IDR

	ldr			r0, =0xFFFE0000			@ TC
	str			r1, [r0, #0x00+0x28]	@ TC0_IDR (interrupt disable register)
	str			r1, [r0, #0x40+0x28]	@ TC1_TDR
	str			r1, [r0, #0x80+0x28]	@ TC2_IDR

	ldr			r0, =0xFFFD0000			@ USART0
	str			r1, [r0, #0x0C]			@ US0_IDR
	ldr			r0, =0xFFFCC000			@ USART1
	str			r1, [r0, #0x0C]			@ US1_IDR

	mov			r1, #0
	ldr			r0, =0xFFFF8000			@ WDT
	str			r1, [r0, #0x00]			@ WD_OMR

	@ -- SecondaryRAM is writable -------------------------
	ldr			r0, =0xFFF00000
	mov			r1, #1
	str			r1, [r0, #0x0c]

init_data_section:       
        @ -- DATA copy ----------------------------------------
	ldr			r1, =_etext
	ldr			r2, =___data
	ldr			r3, =_edata
DataCopyLoop:
	ldr			r0, [r1], #4
	str			r0, [r2], #4
	cmp			r2, r3
	blt			DataCopyLoop

init_bss_section:       
        @ -- BSS clear ----------------------------------------
	mov			r0, #0
	ldr			r1, =_bss_start
	ldr			r2, =_end
BssClearLoop:
	cmp			r1, r2
	beq			ExitBssClearLoop
	str			r0, [r1], #4
	b			BssClearLoop
ExitBssClearLoop:

	bl			main
	b			.
