OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY("_start")
MEMORY
{
	fiqstk(rw)	: o = 0x00300ffc, l = 0x00000004
	irqstk(rw)	: o = 0x00301ffc, l = 0x00000004
	rom(rx)		: o = 0x00000000, l = 0x00008000
	ram(rwx)	: o = 0x00110000, l = 0x0000c000
	stack(rw)	: o = 0x0011fffc, l = 0x00000004
}

SECTIONS
{
.fiqstk : {
	 _fiq_stack = . ; 
	}  > fiqstk
.irqstk : {
	 _irq_stack = . ; 
	}  > irqstk
.text : {
	*(EXCLUDE_FILE( ./aki-arm7/drivers/flash_write.o) .text)
	*(.strings)
	*(.rodata*) 				
	. = ALIGN(0x10) ;  
   	 _etext = . ; 
	} > rom
.data : AT(ADDR(.text) + SIZEOF(.text)) {
	___data = . ;
	./aki-arm7/drivers/flash_write.o
	*(.data)
	. = ALIGN(0x10) ;  
	___ctors = . ;
	*(.ctors)
	___ctors_end = . ;
	. = ALIGN(0x10) ;  
	___dtors = . ;
	*(.dtors)
	___dtors_end = . ;
	. = ALIGN(0x10) ;  
	 _edata = .;
	} > ram

.bss ALIGN(0x10):  {
	 _bss_start = . ;
	*(.bss)
	. = ALIGN(0x10) ;  
	 _end = .;
	end = .;
	}  >ram
.stack : {
	 _stack = . ; 
	}  > stack
}
