/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/*
 *
 */
#include <unistd.h>
#include <signal.h>
#include <pthread.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#include <shmc.h>


static  Shmc *shmc=NULL;

static void disconnect(int arg)
{
  fprintf(stderr, "disconnect: \n");
  if (shmc != NULL) {
    shmcClose(shmc);
    shmc = NULL;
  }
}

static void *rands(void *arg) {
  Shmc *conn = (Shmc *)arg;
  int buf[1000];
  int size = 100*(sizeof(int));

  // struct timespec timeout;

  // timeout.tv_sec = 0;
  // timeout.tv_nsec = 0;
  
  while(1) {
    int r;
    r = shmcRecv(conn, (void *)buf, (size_t)size);
    // fprintf(stderr, "server recv: r is %d\n",r);
    if (r<0) {
      fprintf(stderr, "recv error, closed.\n");
      break;
    }
    if (r==0)
      usleep(10000);
    else {
      r = shmcSend(conn, (void *)buf, (size_t)r);
      // fprintf(stderr, "server send: r is %d\n",r);
      if (r < 0) {
	fprintf(stderr, "send error, closed.\n");
	break;
      }
      if (r==0)
	usleep(10000);
    }
    // fprintf(stderr, ".");
  }
  shmcClose(conn);
  return NULL;
}

int main(int argc, char **argv)
{
  const char *fname = "/var/tmp/rtorb";

  // Shmc *shmc = shmcOpen(fname);
  shmc = shmcOpen(fname);

  signal(SIGINT, disconnect);
  signal(SIGTERM, disconnect);
  
  int r = shmcBind(shmc);
  fprintf (stderr, "bind() returned %d\n", r);
  if (r < 0)
    exit (-1);

  while(1) {
    Shmc *conn = shmcAccept(shmc);
    if (conn==NULL) {
      fprintf(stderr, "accept error\n");
      exit(-1);
    }
    fprintf(stderr, "Accepted: conn->connect is 0x%x\n",(unsigned int)(conn->connect));
    pthread_t *thread = (pthread_t *)malloc(sizeof(pthread_t));
    if(pthread_create(thread, (pthread_attr_t *)NULL, rands, (void*)conn)) {
      /* error ?*/;
      perror("pthread_create");
      // exit(-1);
    }
  }
  shmcClose(shmc);
  shmc=NULL;
  exit(0);
}
