/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/*
 *  RtORB Allocater
 *
 *
 */

#define _GNU_SOURCE
#include <string.h>
#include <RtORB/corba.h>

////////// allocater
void *
RtORB__alloc(long size, const char *info){
  void *retval = (void *)malloc(size * sizeof(char));
  memset(retval, 0, size);
#if DEBUG_MALLOC
  if(info) fprintf(stderr, "malloc in %s: (0x%x)\n", info, (int)retval);
#endif

  return retval;
}

void *
RtORB__calloc(long size, long n, const char *info){
  void *retval = (void *)calloc(size, n);
#if DEBUG_MALLOC
  if(info) fprintf(stderr, "calloc in %s: (0x%x)\n", info, (int)retval);
#endif

  return retval;
}

void *
RtORB__realloc(void *ptr, long size, const char *info){
  void *retval = (void *)realloc(ptr, size);
#if DEBUG_MALLOC
  if(info) fprintf(stderr, "realloc in %s: (0x%x)\n", info, (int)retval);
#endif

  return retval;
}

void *
RtORB_alloc_by_typecode(CORBA_TypeCode tc, int len, const char *info){
  SKIP_ALIAS(tc);
  switch(tc->kind){
    case tk_null:
    case tk_void:
      return NULL;
/*
    case tk_sequence:
      return RtORB_alloc(sizeof(CORBA_SequenceBase) *len , info);
*/
    default:
      return (void *)RtORB_alloc(size_of_typecode(tc) * len, info);
/*
      if (tc->size) return RtORB_alloc(tc->size * len, info);
      else return RtORB_alloc(sizeof(void *) * len, info);
*/
  }
}

void *
RtORB_realloc_by_typecode(void *ptr, CORBA_TypeCode tc, int len, const char *info){
  SKIP_ALIAS(tc);
  switch(tc->kind){
    case tk_null:
    case tk_void:
      return NULL;
/*
    case tk_sequence:
      return RtORB_alloc(sizeof(CORBA_SequenceBase) *len , info);
*/
    default:
      return (void *)RtORB__realloc(ptr, size_of_typecode(tc) * len, info);
/*
      if (tc->size) return RtORB_alloc(tc->size * len, info);
      else return RtORB_alloc(sizeof(void *) * len, info);
*/
  }
}

void 
RtORB__free(void *val, const char *info){
  if(!val) return;
#if DEBUG_MALLOC
  if(info) fprintf(stderr, "FREE in %s: (0x%x)\n", info, (int)val);
#endif
  free(val);
  return;
}

void 
RtORB_free_by_typecode(CORBA_TypeCode tc, void *val, int flag){
   if (!val) return;
   SKIP_ALIAS(tc);
#if DEBUG2
   fprintf(stderr, "  Typecode = %d(%s)\n", (int)tc->kind, tc->repository_id);
#endif
   switch(tc->kind){
      case tk_null:
      case tk_void:
	 return;

      case tk_octet:
      case tk_char:
      case tk_boolean:
	 break;

      case tk_short:
      case tk_ushort:
	 break;
	
      case tk_long:
      case tk_ulong:
	 break;

      case tk_float:
	 break;

      case tk_double:
	 break;

      case tk_string:
         RtORB_free(*(char **)val, "RtORB_free_by_typecode(string)");
	 break;

      case tk_sequence:
	 {
	   int i;
           CORBA_SequenceBase *sb = (CORBA_SequenceBase *)val;
           if(val && sb->_length > 0){
	   void **buf = (void **)sb->_buffer;
	   CORBA_TypeCode _tc = tc->member_type[0];
	   int len = _tc->size;

	   for(i=0;i<sb->_length;i++){
             RtORB_free_by_typecode(_tc, buf, 0);
	     buf = (void **)((char *)buf + len);
	   }
          }
           if(sb->_length > 0)
           RtORB_free(sb->_buffer, "RtORB_free_by_typecode(sequence)");
	 }
	 break;

      case tk_except:
      case tk_struct:
	 {
	   int i;
	   void *tmp;
	   tmp = (void *)val;
	   CORBA_TypeCode _tc;
	   
	   for(i=0;i< tc->member_count;i++){
             _tc = tc->member_type[i];
             RtORB_free_by_typecode(_tc, tmp, 0);
	     tmp = (char *)tmp + _tc->size;
	   }
	 }
	 break;
      case tk_objref:
	 {
	    CORBA_Object obj = *(CORBA_Object *)val;
	    if(!obj) { break;}
#if DEBUG1
	    fprintf(stderr, "CORBA_Object_free: 0x%x, ref=%d\n", (int)obj, (int)obj->ref);
#endif
	    CORBA_Object_free(obj);
	 }
	 break;
      case tk_any:
	{
	  CORBA_any *any = (CORBA_any*)val;
	  if (!any) { break; }
	  CORBA_any_clear(any);
	  break;
	}
      default: 
	 break;
  }
  if(flag) RtORB_free(val, "RtORB_free_by_typecode");
  return;
}

void 
RtORB_free_by_typecode_cpp(CORBA_TypeCode tc, void *val, int flag){
   if (!val) return;
   SKIP_ALIAS(tc);
#ifdef DEBUG2
  fprintf(stderr, "    RtORB_free_by_typecode_cpp:Typecode = %d(%s)\n", (int)tc->kind, tc->repository_id);
#endif

   switch(tc->kind){
      case tk_null:
      case tk_void:
	 return;

      case tk_octet:
      case tk_char:
      case tk_boolean:
	 break;

      case tk_short:
      case tk_ushort:
	 break;
	
      case tk_long:
      case tk_ulong:
	 break;

      case tk_float:
	 break;

      case tk_double:
	 break;

      case tk_string:
	 if(flag)
            RtORB_free(*(char **)val, "RtORB_free_by_typecode_cpp(string)");
	 break;

      case tk_sequence:
	 {
	   int i;
           CORBA_SequenceBase *sb = (CORBA_SequenceBase *)val;

           if(val && sb->_length > 0){
	     void **buf = (void **)sb->_buffer;
	     CORBA_TypeCode _tc = tc->member_type[0];
	     int len = _tc->size;

	     for(i=0;i<sb->_length;i++){
               RtORB_free_by_typecode_cpp(_tc, buf, 0);
               //DEL RtORB_free_by_typecode_cpp(_tc, buf, 1); //ADD
               //RTSystemEditorȤ̿ˤط͡ѹȥݡͥȤ롣
	       buf = (void **)((char *)buf + len);
	     }
             if(sb->_buffer) RtORB_free(sb->_buffer, "RtORB_free_by_typecode_cpp(sequence)");
             sb->_buffer = NULL;
           }
          
	 }
	 break;

      case tk_except:
      case tk_struct:
	 {
	   int i;
	   void *tmp;
	   tmp = val;
	   CORBA_TypeCode _tc;
	   
	   for(i=0;i< tc->member_count;i++){
             _tc = tc->member_type[i];
//             fprintf(stderr, "    Struct=%d(%x)\n", i, tmp);
             RtORB_free_by_typecode_cpp(_tc, tmp, 0);
	     tmp = (char *)tmp + _tc->size;
	   }
	 }
	 break;
      case tk_objref:
	 {
	    CORBA_Object obj = *(CORBA_Object *)val;
	    if(!obj) { break;}
	    if(obj->release) CORBA_Object_free(obj);
	 }
	 break;
      case tk_any:
	{
	  CORBA_any *any = (CORBA_any*)val;
	  if (!any) { break; }
//          fprintf(stderr, "    Free CORBA_any=(%x)\n", any);
	  CORBA_any_clear(any);
	  break;
	}
      default: 
	 break;
  }
  if(flag) RtORB_free(val, "RtORB_free_by_typecode_cpp");
  return;
}

#ifdef __T_KERNEL__


void 
RtORB_free_by_ConfigurationSetList(CORBA_TypeCode tc, void *val, int flag){
   if (!val) return;
   SKIP_ALIAS(tc);
#ifdef DEBUG2
  fprintf(stderr, "    RtORB_free_by_ConfigurationSetList:Typecode = %d(%s)\n", (int)tc->kind, tc->repository_id);
#endif

   switch(tc->kind){
      case tk_null:
      case tk_void:
	 return;

      case tk_octet:
      case tk_char:
      case tk_boolean:
	 break;

      case tk_short:
      case tk_ushort:
	 break;
	
      case tk_long:
      case tk_ulong:
	 break;

      case tk_float:
	 break;

      case tk_double:
	 break;

      case tk_string:
            RtORB_free(*(char **)val, "RtORB_free_by_ConfigurationSetList(string)");
	 break;

      case tk_sequence:
	 {
	   int i;
           CORBA_SequenceBase *sb = (CORBA_SequenceBase *)val;

           if(val && sb->_length > 0){
	     void **buf = (void **)sb->_buffer;
	     CORBA_TypeCode _tc = tc->member_type[0];
	     int len = _tc->size;

	     for(i=0;i<sb->_length;i++){
               RtORB_free_by_ConfigurationSetList(_tc, buf, 0);
	       buf = (void **)((char *)buf + len);
	     }
             if(sb->_buffer) RtORB_free(sb->_buffer, "RtORB_free_by_ConfigurationSetList(sequence)");
             sb->_buffer = NULL;
           }
          
	 }
	 break;

      case tk_except:
      case tk_struct:
	 {
	   int i;
	   void *tmp;
	   tmp = val;
	   CORBA_TypeCode _tc;

	   for(i=0;i< tc->member_count;i++){
             _tc = tc->member_type[i];
//             fprintf(stderr, "    Struct=%d(%x)\n", i, tmp);
             RtORB_free_by_ConfigurationSetList(_tc, tmp, 0);
	     tmp = (char *)tmp + _tc->size;
	   }
	 }
	 break;
      case tk_objref:
	 {
	    CORBA_Object obj = *(CORBA_Object *)val;
	    if(!obj) { break;}
	    if(obj->release) CORBA_Object_free(obj);
	 }
	 break;
      case tk_any:
	{
	  CORBA_any *any = (CORBA_any*)val;
	  if (!any) { break; }
//          fprintf(stderr, "    Free CORBA_any=(%x)\n", any);
	  CORBA_any_clear(any);
	  break;
	}
      default: 
	 break;
  }
  
  if(flag) RtORB_free(val, "RtORB_free_by_ConfigurationSetList");
  
  return;
}

#endif

void 
RtORB_free_unmarhsal_data_by_typecode(CORBA_TypeCode tc, void *val, int flag)
{
   if (!val) return;
   SKIP_ALIAS(tc);

   switch(tc->kind){

#ifdef __T_KERNEL__
      case tk_string:
#ifdef DEBUG_T_KERNEL
         printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
	 if(flag)
            RtORB_free(*(char **)val, "RtORB_free_unmarhsal_data_by_typecode(string)");
#ifdef DEBUG_T_KERNEL
         printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
	 break;
#endif

     case tk_sequence:
       {
          int i;
          CORBA_SequenceBase *sb = (CORBA_SequenceBase *)val;

           if(val && sb->_length > 0){
	     void **buf = (void **)sb->_buffer;
	     CORBA_TypeCode _tc = tc->member_type[0];
	     int len = _tc->size;

	     for(i=0;i<sb->_length;i++){
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
               printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
               RtORB_free_unmarhsal_data_by_typecode(_tc, buf, 1);
#ifdef DEBUG_T_KERNEL
               printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
               RtORB_free_by_typecode_cpp(_tc, buf, 0);
#endif
	       buf = (void **)((char *)buf + len);
	     }
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
             printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
             RtORB_free(sb->_buffer, "RtORB_free_unmarhsal_data_by_typecode");
#ifdef DEBUG_T_KERNEL
             printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
             RtORB_free(sb->_buffer, "RtORB_free_by_typecode_cpp(sequence)");
#endif
             sb->_buffer = NULL;
           }
          
      }
      break;
    default:
      break;
  }
}

/*
 *  RtORB_Arguments_free:
 *
 *   See deMarshal_Arg function(giop-marshal.c)
 */

void 
RtORB_Arguments_free(void **argv, int in_argc, CORBA_IArg *in_argv){
  int i;

  for(i=0;i<in_argc;i++){
    if(in_argv[i].io == CORBA_I_ARG_IN ){
      RtORB_free_by_typecode(in_argv[i].tc, argv[i], 1);
    }
/*
     else if(in_argv[i].io == CORBA_I_ARG_OUT ){
      CORBA_TypeCode tc = in_argv[i].tc;
      SKIP_ALIAS(tc);
      switch(tc->kind) {
      case tk_sequence:
      case tk_union:
        RtORB_free_by_typecode(in_argv[i].tc, argv[i], 1);
        break;
      default:
        RtORB_free_by_typecode(in_argv[i].tc, *(void **)argv[i], 1);
        RtORB_free(argv[i], "RtORB_Arguments_free");
        break;
      }
    }
*/
  }
  return;
}

void
RtORB_Result__free(CORBA_TypeCode tc, void **result){
  SKIP_ALIAS(tc);
  switch(tc->kind){
  case tk_null:
  case tk_void:
    return;
  case tk_alias:
    RtORB_Result__free(tc->member_type[0], result);
    return;
  case tk_struct:
    RtORB_free_by_typecode(tc, (void*)result, 1);
    return;
  case tk_sequence:
    RtORB_free_by_typecode(tc, (void*)result, 1);
    return;
  default:
    break;
  }
  if (CORBA_TypeCode_is_fixed_size(tc)) {
    RtORB_free_by_typecode(tc, (void*)result, 1);
  } else {
    RtORB_free_by_typecode(tc, result[0], 1);
    RtORB__free(result, "RtORB_Result_free");
  }
  return;
}

void
RtORB_Result__free_cpp(CORBA_TypeCode tc, void **result){

#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
  printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
  int flag = 0;
  if(tc->repository_id)
  {
    if( 0 == strcmp(tc->repository_id, "IDL:org.omg/SDOPackage/ConfigurationSetList:1.0") ) flag = 1;
  }
#ifdef DEBUG_T_KERNEL
  printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#endif
  
  SKIP_ALIAS(tc);

  switch(tc->kind){
  case tk_null:
  case tk_void:
    return;
  case tk_struct:
  case tk_sequence:
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    if(flag)
    {
      RtORB_free_by_ConfigurationSetList(tc, (void*)result, 1);
    }else{
      RtORB_free_by_typecode_cpp(tc, (void*)result, 1);
    }
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
    RtORB_free_by_typecode_cpp(tc, (void*)result, 1);
#endif
    return;
  default:
    break;
  }
  if (CORBA_TypeCode_is_fixed_size(tc)) {
    RtORB_free_by_typecode_cpp(tc, (void*)result, 1);
  } else {
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    RtORB_free_by_typecode_cpp(tc, result[0], 0);
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
    RtORB_free_by_typecode_cpp(tc, result[0], 1);
#endif
    RtORB__free(result, "RtORB_Result_free_cpp");
  }
  return;
}
//////////////////////////////////
/*
 * void *
 * RtORB_typecode_alloc(CORBA_TypeCode)
 *
 */
void *
RtORB_typecode_alloc(CORBA_TypeCode tc){
  return (void *)RtORB_calloc(size_of_typecode(tc), 1, "RtORB_typecode_alloc");
}
/*
 * void
 * RtORB__freekids(CORBA_TypeCode, void *, void *)
 *
 */
void
RtORB__freekids(CORBA_TypeCode tc, void *p, void *d){
  RtORB_free_by_typecode(tc, p, 1);
  return;
}

/*
 * void *
 * RtORB__allocbuf(CORBA_TypeCode, long )
 *
 */
void *
RtORB__allocbuf(CORBA_TypeCode tc, long length){
  return RtORB_alloc_by_typecode(tc->member_type[0], length, "RtORB__allocbuf");
}

void *
RtORB__reallocbuf(void *ptr, CORBA_TypeCode tc, long length){
  return RtORB_realloc_by_typecode(ptr, tc->member_type[0], length, "RtORB__reallcbuf");
}

/*
 * void *
 * RtORB_sequence_allocbuf(CORBA_TypeCode, long )
 *
 */
void *
RtORB_sequence_allocbuf(CORBA_TypeCode tc, long length){
  return RtORB_alloc_by_typecode(tc->member_type[0], length, "RtORB_sequence_allocbuf");
}


//// Strdup

char * RtORB__strdup(const char *str, const char *info){
   char *retval;
   retval = strdup(str);
#if DEBUG_MALLOC
   if(info) fprintf(stderr, "strdup in %s: (0x%x) : %s\n", info, (int)retval, str);
#endif
   return retval;

}

#ifdef __T_KERNEL__
char* tk_strndup(const char * src, size_t n)
{
#ifdef DEBUG_T_KERNEL
   printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
   char *retval;
   int len = strlen(src);
   int size = len >= n ? n : len;
   retval = (char*)malloc(size+1);
   if( retval ) {
       memset(retval, 0, size+1);
       strncpy(retval, src, size);
   }
#ifdef DEBUG_T_KERNEL
   printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
   return retval;
}
#endif

char * RtORB__strndup(const char *str, int n, const char *info){
   char *retval;
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
   printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
   retval = tk_strndup(str, n);
#ifdef DEBUG_T_KERNEL
   printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
#else
   retval = strndup(str, n);
#endif
#if DEBUG_MALLOC
   if(info) fprintf(stderr, "strndup in %s: (0x%x)\n", info, (int)retval);
#endif
   return retval;

}
