/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/*
 *
 */
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#include <shmc.h>


static  Shmc *accept=NULL;

static void disconnect(int arg)
{
  fprintf(stderr, "disconnect: \n");
  if (accept != NULL) {
    shmcClose(accept);
    accept = NULL;
  }
  exit(-1);
}

int main(int argc, char **argv)
{
  const char *fname = "/var/tmp/rtorb";

  // Shmc *shmc = shmcOpen(fname);
  accept = shmcOpen(fname);

  signal(SIGINT, disconnect);
  signal(SIGTERM, disconnect);
  
  int r = shmcBind(accept);
  fprintf (stderr, "bind() returned %d\n", r);
  if (r < 0)
    exit(-1);

  // struct timespec timeout;
  // timeout.tv_sec =  10;
  // timeout.tv_nsec = 0;

  int buf[1000];
  // int size = 800*(sizeof(int));
  int size;
  if (argc > 1) {
    size = atoi(argv[1])*(sizeof(int));
  } else {
    size = 800*(sizeof(int));
  }
  fprintf(stderr, "server3: start, size is %d\n", size);

  ShmcSet set[21];
  int num= 0;
  Shmc *shmc_table[20];

  for (num=0;num<10;num++)
    shmc_table[num] = NULL;
  num = 0;

  while(1) {
    int i;
    int count;

    SHMC_SET(set, 0, accept);
    count = 1;
    for (i=0; i<20; i++) {
      if(shmc_table[i] != NULL) {
	SHMC_SET(set, count, shmc_table[i]);
	count++;
      }
    }
    // timeout.tv_sec = 10;
    // fprintf(stderr, "shmcSelect: count is %d\n",count);
    // r = shmcSelect(count, set, 0, NULL, &timeout);
    r = shmcSelect(count, set, 0, NULL, NULL);
    // fprintf(stderr, "shmcSelect: r is %d\n",r);
    if (r <= 0) {
      continue;
    }
    for (i=0; i<count; i++) {
      if (SHMC_ISSET(set, i)) {
	Shmc *conn = SHMC_GET(set, i);
	if (conn == accept) {
	  fprintf(stderr, "try new accept\n");
	  Shmc *conn = shmcAccept(accept);
	  fprintf(stderr, "accepted, conn is 0x%x\n", (unsigned int)conn);
	  if (conn==NULL) {
	    fprintf(stderr, "accept error\n");
	    exit(-1);
	  }
	  {
	    int i;
	    for (i=0; i<20; i++) {
	      if (shmc_table[i] == NULL) {
		shmc_table[i] = conn;
		num++;
		// fprintf(stderr, "num is %d\n", num);
		break;
	      }
	    }
	  }
  	} else {
	  // timeout.tv_sec = 10;
	  int rsize = shmcRecvB(conn, (void *)buf, (size_t)size, NULL);
	  if (rsize < 0) {
	    int i;
	    for (i=0; i<20; i++) {
	      if(shmc_table[i] == conn) {
		fprintf(stderr, "close %d\n", i);
		shmcClose(conn);
		shmc_table[i] = NULL;
		num--;
		break;
	      }
	    }
	  } else {
	    // timeout.tv_sec = 10;
	    shmcSendB(conn, (void *)buf, (size_t)rsize, NULL);
	    // fprintf(stderr, "shmcSendB: w is %d\n", w); 
	  }
	}
      }
    }
  }
  shmcClose(accept);
  accept=NULL;
  exit(0);
}
