/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/*
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

#include <shmc.h>

static  Shmc *shmc=NULL;

/*
static void disconnect(void)
{
  fprintf(stderr, "disconnect: \n");
  if (shmc != NULL)
    shmcClose(shmc);
}
*/

int main(int argc, char **argv)
{

  // atexit(disconnect);

  const char *fname = "/var/tmp/rtorb";
  int iter = 1000;

  if (argc > 1) {
    iter = atoi(argv[1]);
  }
  fprintf(stderr, "client2: start, iter is %d\n", iter);
  // Shmc *shmc = shmcOpen(fname);
  shmc = shmcOpen(fname);

  int r = shmcConnect(shmc);
  fprintf (stderr, "shmcConnect() returned %d, shmc->connect is 0x%x\n",
	   r, (unsigned int)(shmc->connect));

  if (r<0)
    exit(-1);

  int i;
  struct timespec timeout;
  int sendbuf[1000];
  int recvbuf[1000];
  int count = 800;
  int size = count*(sizeof(int));

  timeout.tv_sec = 10;
  timeout.tv_nsec = 0;

  for (i=0; i<1000;i++)
    sendbuf[i] = i;

  for (i=0; i<iter; i++) {
    // fprintf(stderr, "send: i is %d\n",i);
    int r;
    // r = shmcSend(shmc, (void*)sendbuf+p, (size_t)s);
    r = shmcSendB(shmc, (void*)sendbuf, (size_t)size, &timeout);
    // fprintf(stderr, "send: r is %d\n",r);
    if (r < 0) {
      // fprintf(stderr, "recv: timeout %d\n",(int)timeout.tv_sec);
      perror("send error");
      shmcClose(shmc);
      exit(-1);
    }
    // r = shmcRecv(shmc, (void*)recvbuf+p, (size_t)s);
    r = shmcRecvB(shmc, (void*)recvbuf, (size_t)size, &timeout);
    // fprintf(stderr, "recv: r is %d\n",r);
    if (r < 0) {
      // fprintf(stderr, "recv: timeout %d\n",(int)timeout.tv_sec);
      perror("recv error");
      shmcClose(shmc);
      exit(-1);
    }
    int j;
    for (j=0; j<count; j++) {
      if (sendbuf[j] != recvbuf[j])
	fprintf(stderr, "send is %d, recv is %d",sendbuf[j],recvbuf[j]);
      recvbuf[j] = 0;
    }
    if (i%100 == 0)
      fprintf(stderr, ".");
  }
  shmcClose(shmc);
  shmc = NULL;

  fprintf(stderr, "client2: end\n");
  exit(0);
}
