/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/*
 * Shmc: An attempting to replace the UNIX domain socket,
 * with semaphore and sharedmemory.
 *
 * $Id: shmc.h,v 1.10 2008/05/29 06:28:51 kuroba Exp $
 */
#ifndef shmc_h
#define shmc_h

#include <sys/time.h>

//
#define SHMC_MAX_CONN     100       // max connection number
#define SHMC_SEND_SIZE   (1024*16)  // MAX size of sending area
#define SHMC_RECV_SIZE   (1024*16)  // MAX size of receiving area

#ifdef __cplusplus
extern "C" {
#endif

// for handling each Connection (internal use)
struct ShmcConn;
typedef struct _Shmc Shmc;

// Basic structure (handling all connection)
struct _Shmc {
  char *app_key;
  key_t shmc_key;
  int type;
  int sem_id;       // semaphore id for send and receive
  int sem_id_b;     // for blocking IO
  int sem_id_s;     // for select function
  int sem_id_w;     // for wait-wakeup
  struct ShmcConn *connect;
  void **accept;
  void (*close)(Shmc*);
};

Shmc *shmcOpen(const char *key);
void shmcClose(Shmc *shmc);
int  shmcBind(Shmc *shmc);
Shmc *shmcAccept(Shmc *shmc);
 
int  shmcConnect(Shmc *shmc);

int  shmcRecv(Shmc *shmc, char *buf, size_t size);
int  shmcSend(Shmc *shmc, char *data, size_t size);

int  shmcRecvB(Shmc *shmc, char *buf, size_t size, struct timespec *timeout);
int  shmcSendB(Shmc *shmc, char *data, size_t size, struct timespec *timeout);

//
typedef struct {
  Shmc *shmc;
  int  set;
} ShmcSet;

#define SHMC_SET(shmc_set, n, shmcp) { shmc_set[n].shmc=shmcp; shmc_set[n].set=0; }
#define SHMC_ISSET(shmc_set, n) (shmc_set[n].set==1)
#define SHMC_GET(shmc_set, n) (shmc_set[n].shmc)
#define SHMC_CLR(shmc_set, n) shmc_set[n].shmc = NULL; shmc_set[n].set = 0;

int  shmcSelect(int r_num, ShmcSet *set_r, int w_num, ShmcSet *set_w,
                struct timespec *timeout);

#ifdef __cplusplus
}
#endif

#endif /* shmc_h */
