/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>
#include <time.h>

int main()
{
	int id;

	key_t key;
	key = ftok("foo.key", 'R');
	if (key == -1) {
		perror("ftok");
		return 1;
	}
	id = shmget(key, 512, IPC_CREAT | 0666);
	if (id == -1) {
		perror("shmget");
		return 1;
	}
	printf("id = %d\n", id);

	char *mem = shmat(id, 0, 0);
	if ( mem == (void*) -1) {
		perror("shmat");
		return 1;
	}
	strcpy(mem, "init");


	time_t last;
	time(&last);
	struct shmid_ds ds;
	while (1) {

		/*
		if (shmctl(id, IPC_STAT, &ds) == -1) {
			perror("shmctl");
			break;
		}
		*/

		/*
		printf("%s\n", ctime(&ds.shm_ctime));
		if (ds.shm_ctime > last) {
		*/
		{
			printf("%s\n", mem);
			last = ds.shm_ctime;
		}
		//sleep(5);

	}
	if (shmctl(id, IPC_RMID, 0) == -1) {
		perror("shmctl");
		return 1;
	}
	if (shmdt(mem) == -1) {
		perror("shmdt");
	}


	return 0;
}
